<?php
/**
 * Captcha Overlay Template
 * This file renders the HTML structure for the captcha overlay
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get plugin URL for images
$plugin_url = plugin_dir_url(dirname(__FILE__));
?>

<!-- Cloudflare Captcha Images -->
<script>
window.cfCaptchaImages = {
    logoWithText: '<?php echo esc_url($plugin_url . 'assets/images/cloudflare-logo.png'); ?>',
    cloudColor: '<?php echo esc_url($plugin_url . 'assets/images/cloudflare-color.png'); ?>',
    fingerprint: '<?php echo esc_url($plugin_url . 'assets/images/fingerprint.png'); ?>',
    clock: '<?php echo esc_url($plugin_url . 'assets/images/clock.png'); ?>',
    shield: '<?php echo esc_url($plugin_url . 'assets/images/shield.png'); ?>'
};
</script>

<!-- Cloudflare Captcha Overlay Container -->
<div id="cf-captcha-overlay" class="cf-captcha-overlay" data-captcha-modal>
    <div id="cf-captcha-container"></div>
</div>
