/*! For license information please see editor-controls.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/libs/editor-controls/src/api.ts":function(e,t,r){r.r(t),r.d(t,{apiClient:function(){return a}});var o=r("@elementor/http-client");const n="elementor/v1/settings",a={getElementorSetting:e=>(0,o.httpService)().get(`${n}/${e}`).then(e=>formatSettingResponse(e.data)),updateElementorSetting:(e,t)=>(0,o.httpService)().put(`${n}/${e}`,{value:t})},formatSettingResponse=e=>e.data.value},"./packages/packages/libs/editor-controls/src/bound-prop-context/errors.ts":function(e,t,r){r.r(t),r.d(t,{HookOutsideProviderError:function(){return l},MissingPropTypeError:function(){return n},UnsupportedParentError:function(){return a}});var o=r("@elementor/utils");const n=(0,o.createError)({code:"missing_prop_provider_prop_type",message:"Prop type is missing"}),a=(0,o.createError)({code:"unsupported_prop_provider_prop_type",message:"Parent prop type is not supported"}),l=(0,o.createError)({code:"hook_outside_provider",message:"Hook used outside of provider"})},"./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts":function(e,t,r){r.r(t),r.d(t,{PropKeyProvider:function(){return n.PropKeyProvider},PropProvider:function(){return o.PropProvider},useBoundProp:function(){return a.useBoundProp},usePropContext:function(){return o.usePropContext},usePropKeyContext:function(){return n.usePropKeyContext}});var o=r("./packages/packages/libs/editor-controls/src/bound-prop-context/prop-context.tsx"),n=r("./packages/packages/libs/editor-controls/src/bound-prop-context/prop-key-context.tsx"),a=r("./packages/packages/libs/editor-controls/src/bound-prop-context/use-bound-prop.ts")},"./packages/packages/libs/editor-controls/src/bound-prop-context/prop-context.tsx":function(e,t,r){r.r(t),r.d(t,{PropProvider:function(){return PropProvider},usePropContext:function(){return usePropContext}});var o=r("react"),n=r("./packages/packages/libs/editor-controls/src/bound-prop-context/errors.ts");const a=(0,o.createContext)(null),PropProvider=({children:e,value:t,setValue:r,propType:n,placeholder:l,isDisabled:s})=>o.createElement(a.Provider,{value:{value:t,propType:n,setValue:r,placeholder:l,isDisabled:s}},e),usePropContext=()=>{const e=(0,o.useContext)(a);if(!e)throw new n.HookOutsideProviderError({context:{hook:"usePropContext",provider:"PropProvider"}});return e}},"./packages/packages/libs/editor-controls/src/bound-prop-context/prop-key-context.tsx":function(e,t,r){r.r(t),r.d(t,{PropKeyProvider:function(){return PropKeyProvider},usePropKeyContext:function(){return usePropKeyContext}});var o=r("react"),n=r("./packages/packages/libs/editor-controls/src/bound-prop-context/errors.ts"),a=r("./packages/packages/libs/editor-controls/src/bound-prop-context/prop-context.tsx");const l=(0,o.createContext)(null),PropKeyProvider=({children:e,bind:t})=>{const{propType:r}=(0,a.usePropContext)();if(!r)throw new n.MissingPropTypeError({context:{bind:t}});if("array"===r.kind)return o.createElement(ArrayPropKeyProvider,{bind:t},e);if("object"===r.kind)return o.createElement(ObjectPropKeyProvider,{bind:t},e);throw new n.UnsupportedParentError({context:{propType:r}})},ObjectPropKeyProvider=({children:e,bind:t})=>{const r=(0,a.usePropContext)(),{path:n}=(0,o.useContext)(l)??{},s=r.value?.[t],c=r.placeholder?.[t],i=r.propType.shape[t];return o.createElement(l.Provider,{value:{...r,value:s,setValue:(e,o,n)=>{const a={...r.value,[t]:e};return r?.setValue(a,o,{...n,bind:t})},placeholder:c,bind:t,propType:i,path:[...n??[],t]}},e)},ArrayPropKeyProvider=({children:e,bind:t})=>{const r=(0,a.usePropContext)(),{path:n}=(0,o.useContext)(l)??{},s=r.value?.[Number(t)],c=r.propType.item_prop_type;return o.createElement(l.Provider,{value:{...r,value:s,setValue:(e,o)=>{const n=[...r.value??[]];return n[Number(t)]=e,r?.setValue(n,o,{bind:t})},bind:t,propType:c,path:[...n??[],t]}},e)},usePropKeyContext=()=>{const e=(0,o.useContext)(l);if(!e)throw new n.HookOutsideProviderError({context:{hook:"usePropKeyContext",provider:"PropKeyProvider"}});return e}},"./packages/packages/libs/editor-controls/src/bound-prop-context/use-bound-prop.ts":function(e,t,r){r.r(t),r.d(t,{useBoundProp:function(){return useBoundProp}});var o=r("react"),n=r("./packages/packages/libs/editor-controls/src/bound-prop-context/errors.ts"),a=r("./packages/packages/libs/editor-controls/src/bound-prop-context/prop-key-context.tsx");function useBoundProp(e){const t=(0,a.usePropKeyContext)(),{isValid:r,validate:o,restoreValue:n}=useValidation(t.propType),l=t.isDisabled?.(t.propType);if(!e)return{...t,disabled:l};const s=resolveUnionPropType(t.propType,e.key),c=e.extract(t.value??s.default??null),i=e.extract(t.placeholder??null);return{...t,propType:s,setValue:function setValue(r,n,a){if(o(r))return null===r?t?.setValue(null,n,a):t?.setValue(e?.create(r,n),{},a)},value:r?c:null,restoreValue:n,placeholder:i,disabled:l}}const useValidation=e=>{const[t,r]=(0,o.useState)(!0);return{isValid:t,setIsValid:r,validate:t=>{let o=!0;return e.settings.required&&null===t&&(o=!1),r(o),o},restoreValue:()=>r(!0)}},resolveUnionPropType=(e,t)=>{let r=e;if("union"===e.kind&&(r=e.prop_types[t]),!r)throw new n.MissingPropTypeError({context:{key:t}});return r}},"./packages/packages/libs/editor-controls/src/components/autocomplete.tsx":function(e,t,r){r.r(t),r.d(t,{Autocomplete:function(){return l},findMatchingOption:function(){return findMatchingOption},isCategorizedOptionPool:function(){return isCategorizedOptionPool}});var o=r("react"),n=r("@elementor/icons"),a=r("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const l=(0,o.forwardRef)((e,t)=>{const{options:r,onOptionChange:n,onTextChange:l,allowCustomValues:s=!1,placeholder:c="",minInputLength:i=2,value:u="",...p}=e,d=function _factoryFilter(e,t,r){if(null===e)return t;const o=String(e||"")?.toLowerCase();if(o.length<r)return new Array(0);return t.filter(e=>String(e.id).toLowerCase().includes(o)||e.label.toLowerCase().includes(o))}(u,r,i).map(({id:e})=>e),m=!!u,g=s||!!u?.toString()?.length?void 0:()=>!0,b="number"==typeof u&&!!findMatchingOption(r,u);return o.createElement(a.Autocomplete,_extends({},p,{ref:t,forcePopupIcon:!1,disableClearable:!0,freeSolo:s,value:u?.toString()||"",size:"tiny",onChange:(e,t)=>n(Number(t)),readOnly:b,options:d,getOptionKey:e=>findMatchingOption(r,e)?.id||e,getOptionLabel:e=>findMatchingOption(r,e)?.label||e.toString(),groupBy:isCategorizedOptionPool(r)?e=>findMatchingOption(r,e)?.groupLabel||e:void 0,isOptionEqualToValue:g,filterOptions:()=>d,renderOption:(e,t)=>o.createElement(a.Box,_extends({component:"li"},e,{key:e.id}),findMatchingOption(r,t)?.label??t),renderInput:e=>o.createElement(TextInput,{params:e,handleChange:e=>l?.(e),allowClear:m,placeholder:c,hasSelectedValue:b})}))}),TextInput=({params:e,allowClear:t,placeholder:r,handleChange:n,hasSelectedValue:l})=>o.createElement(a.TextField,_extends({},e,{placeholder:r,onChange:e=>{n(e.target.value)},sx:{"& .MuiInputBase-input":{cursor:l?"default":void 0}},InputProps:{...e.InputProps,endAdornment:o.createElement(ClearButton,{params:e,allowClear:t,handleChange:n})}})),ClearButton=({allowClear:e,handleChange:t,params:r})=>o.createElement(a.InputAdornment,{position:"end"},e&&o.createElement(a.IconButton,{size:r.size,onClick:()=>t(null),sx:{cursor:"pointer"}},o.createElement(n.XIcon,{fontSize:r.size})));function findMatchingOption(e,t=null){const r=(t||"").toString();return e.find(({id:e})=>r===e.toString())}function isCategorizedOptionPool(e){return e.every(e=>"groupLabel"in e)}},"./packages/packages/libs/editor-controls/src/components/conditional-tooltip.tsx":function(e,t,r){r.r(t),r.d(t,{ConditionalTooltip:function(){return ConditionalTooltip}});var o=r("react"),n=r("@elementor/ui");const ConditionalTooltip=({showTooltip:e,children:t,label:r})=>e&&r?o.createElement(n.Tooltip,{title:r,disableFocusListener:!0,placement:"top"},t):t},"./packages/packages/libs/editor-controls/src/components/control-form-label.tsx":function(e,t,r){r.r(t),r.d(t,{ControlFormLabel:function(){return ControlFormLabel}});var o=r("react"),n=r("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const ControlFormLabel=e=>o.createElement(n.FormLabel,_extends({size:"tiny"},e))},"./packages/packages/libs/editor-controls/src/components/control-label.tsx":function(e,t,r){r.r(t),r.d(t,{ControlLabel:function(){return ControlLabel}});var o=r("react"),n=r("@elementor/ui"),a=r("./packages/packages/libs/editor-controls/src/control-adornments/control-adornments.tsx"),l=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx");const ControlLabel=({children:e})=>o.createElement(n.Stack,{direction:"row",alignItems:"center",justifyItems:"start",gap:.25},o.createElement(l.ControlFormLabel,null,e),o.createElement(a.ControlAdornments,null))},"./packages/packages/libs/editor-controls/src/components/control-toggle-button-group.tsx":function(e,t,r){r.r(t),r.d(t,{ControlToggleButtonGroup:function(){return ControlToggleButtonGroup}});var o=r("react"),n=r("@elementor/icons"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx"),s=r("./packages/packages/libs/editor-controls/src/components/conditional-tooltip.tsx");const c=(0,a.styled)(a.ToggleButtonGroup)`
	${({justify:e})=>`justify-content: ${e};`}
	button:not( :last-of-type ) {
		border-start-end-radius: 0;
		border-end-end-radius: 0;
	}
	button:not( :first-of-type ) {
		border-start-start-radius: 0;
		border-end-start-radius: 0;
	}
	button:last-of-type {
		border-start-end-radius: 8px;
		border-end-end-radius: 8px;
	}
`,i=(0,a.styled)(a.ToggleButton,{shouldForwardProp:e=>"isPlaceholder"!==e})`
	${({theme:e,isPlaceholder:t})=>t&&`\n\t\tcolor: ${e.palette.text.tertiary};\n\t\tbackground-color: ${"dark"===e.palette.mode?"rgba(255,255,255,0.04)":"rgba(0,0,0,0.02)"};\n\t\t\n\t\t&:hover {\n\t\t\tbackground-color: ${"dark"===e.palette.mode?"rgba(255,255,255,0.08)":"rgba(0,0,0,0.04)"};\n\t\t}\n\t`}
`,ControlToggleButtonGroup=({justify:e="end",size:t="tiny",value:r,onChange:n,items:u,maxItems:p,exclusive:d=!1,fullWidth:m=!1,disabled:g,placeholder:b})=>{const f=d&&void 0!==p&&u.length>p,k=f?u.slice(p-1):[],v=f?u.slice(0,p-1):u,x="rtl"===(0,a.useTheme)().direction,y=(0,o.useMemo)(()=>{const e=k?.length;return`repeat(${e?v.length+1:v.length}, minmax(0, 25%)) ${e?"auto":""}`},[k?.length,v.length]),E=d&&(null==r||""===r),_=!d&&Array.isArray(r)?r.map(e=>"string"==typeof e?e:"").join(" ").trim().split(/\s+/).filter(Boolean):[],h=!d&&0===_.length,P=(C=b,Array.isArray(C)?C.flatMap(e=>"string"==typeof e?e.trim().split(/\s+/).filter(Boolean):[]):"string"==typeof C?C.trim().split(/\s+/).filter(Boolean):[]);var C;return o.createElement(l.default,null,o.createElement(c,{justify:e,value:r,onChange:(e,t)=>{n(t)},exclusive:d,disabled:g,sx:{direction:x?"rtl /* @noflip */":"ltr /* @noflip */",display:"grid",gridTemplateColumns:y,width:"100%"}},v.map(({label:e,value:r,renderContent:n,showTooltip:a})=>{const l=P.length>0&&P.includes(r)&&(E||h);return o.createElement(s.ConditionalTooltip,{key:r,label:e,showTooltip:a||!1},o.createElement(i,{value:r,"aria-label":e,size:t,fullWidth:m,isPlaceholder:l},o.createElement(n,{size:t})))}),k.length&&d&&o.createElement(SplitButtonGroup,{size:t,value:r||null,onChange:n,items:k,fullWidth:m})))},SplitButtonGroup=({size:e="tiny",onChange:t,items:r,fullWidth:l,value:s})=>{const c=usePreviewButton(r,s),[i,u]=(0,o.useState)(!1),p=(0,o.useRef)(null),onMenuItemClick=e=>{u(!1),onToggleItem(e)},onToggleItem=e=>{t(e===s?null:e)};return o.createElement(o.Fragment,null,o.createElement(a.ToggleButton,{value:c.value,"aria-label":c.label,size:e,fullWidth:l,onClick:e=>{e.preventDefault(),onMenuItemClick(c.value)},ref:p},c.renderContent({size:e})),o.createElement(a.ToggleButton,{size:e,"aria-expanded":i?"true":void 0,"aria-haspopup":"menu","aria-pressed":void 0,onClick:e=>{u(e=>!e),e.preventDefault()},ref:p,value:"__chevron-icon-button__"},o.createElement(n.ChevronDownIcon,{fontSize:e})),o.createElement(a.Menu,{open:i,onClose:()=>u(!1),anchorEl:p.current,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},sx:{mt:.5}},r.map(({label:e,value:t})=>o.createElement(a.MenuItem,{key:t,selected:t===s,onClick:()=>onMenuItemClick(t)},o.createElement(a.ListItemText,null,o.createElement(a.Typography,{sx:{fontSize:"14px"}},e))))))},usePreviewButton=(e,t)=>{const[r,n]=(0,o.useState)(e.find(e=>e.value===t)??e[0]);return(0,o.useEffect)(()=>{const r=e.find(e=>e.value===t);r&&n(r)},[e,t]),r}},"./packages/packages/libs/editor-controls/src/components/enable-unfiltered-modal.tsx":function(e,t,r){r.r(t),r.d(t,{EnableUnfilteredModal:function(){return EnableUnfilteredModal}});var o=r("react"),n=r("@elementor/editor-current-user"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/hooks/use-unfiltered-files-upload.ts");const c=(0,l.__)("Enable Unfiltered Uploads","elementor"),i=(0,l.__)("Before you enable unfiltered files upload, note that such files include a security risk. Elementor does run a process to remove possible malicious code, but there is still risk involved when using such files.","elementor"),u=(0,l.__)("Sorry, you can't upload that file yet","elementor"),p=(0,l.__)("This is because this file type may pose a security risk. To upload them anyway, ask the site administrator to enable unfiltered file uploads.","elementor"),d=(0,l.__)("Failed to enable unfiltered files upload.","elementor"),m=(0,l.__)("You can try again, if the problem persists, please contact support.","elementor"),EnableUnfilteredModal=e=>{const{mutateAsync:t,isPending:r}=(0,s.useUpdateUnfilteredFilesUpload)(),{canUser:a}=(0,n.useCurrentUserCapabilities)(),[l,c]=(0,o.useState)(!1),i=a("manage_options"),u={...e,isPending:r,handleEnable:async()=>{try{const r=await t({allowUnfilteredFilesUpload:!0});!1===r?.data?.success?c(!0):e.onClose(!0)}catch{c(!0)}},isError:l,onClose:t=>{e.onClose(t),setTimeout(()=>c(!1),300)}};return i?o.createElement(AdminDialog,u):o.createElement(NonAdminDialog,u)},AdminDialog=({open:e,onClose:t,handleEnable:r,isPending:n,isError:s})=>o.createElement(a.Dialog,{open:e,maxWidth:"sm",onClose:()=>t(!1)},o.createElement(a.DialogHeader,{logo:!1},o.createElement(a.DialogTitle,null,c)),o.createElement(a.Divider,null),o.createElement(a.DialogContent,null,o.createElement(a.DialogContentText,null,s?o.createElement(o.Fragment,null,d," ",o.createElement("br",null)," ",m):i)),o.createElement(a.DialogActions,null,o.createElement(a.Button,{size:"medium",color:"secondary",onClick:()=>t(!1)},(0,l.__)("Cancel","elementor")),o.createElement(a.Button,{size:"medium",onClick:()=>r(),variant:"contained",color:"primary",disabled:n},n?o.createElement(a.CircularProgress,{size:24}):(0,l.__)("Enable","elementor")))),NonAdminDialog=({open:e,onClose:t})=>o.createElement(a.Dialog,{open:e,maxWidth:"sm",onClose:()=>t(!1)},o.createElement(a.DialogHeader,{logo:!1},o.createElement(a.DialogTitle,null,u)),o.createElement(a.Divider,null),o.createElement(a.DialogContent,null,o.createElement(a.DialogContentText,null,p)),o.createElement(a.DialogActions,null,o.createElement(a.Button,{size:"medium",onClick:()=>t(!1),variant:"contained",color:"primary"},(0,l.__)("Got it","elementor"))))},"./packages/packages/libs/editor-controls/src/components/floating-bar.tsx":function(e,t,r){r.r(t),r.d(t,{FloatingActionsBar:function(){return FloatingActionsBar},useFloatingActionsBar:function(){return useFloatingActionsBar}});var o=r("react"),n=r("@elementor/ui");const a=(0,n.styled)("span")`
	display: contents;

	.MuiFloatingActionBar-popper:has( .MuiFloatingActionBar-actions:empty ) {
		display: none;
	}

	.MuiFloatingActionBar-popper {
		z-index: 1000;
	}
`,l=(0,o.createContext)(null);function FloatingActionsBar({actions:e,children:t}){const[r,s]=(0,o.useState)(!1);return o.createElement(l.Provider,{value:{open:r,setOpen:s}},o.createElement(a,null,o.createElement(n.UnstableFloatingActionBar,{actions:e,open:r||void 0},t)))}function useFloatingActionsBar(){const e=(0,o.useContext)(l);if(!e)throw new Error("useFloatingActions must be used within a FloatingActionsBar");return e}},"./packages/packages/libs/editor-controls/src/components/font-family-selector.tsx":function(e,t,r){r.r(t),r.d(t,{FontFamilySelector:function(){return FontFamilySelector}});var o=r("react"),n=r("@elementor/editor-ui"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("@elementor/utils"),c=r("@wordpress/i18n"),i=r("./packages/packages/libs/editor-controls/src/controls/font-family-control/enqueue-font.tsx"),u=r("./packages/packages/libs/editor-controls/src/hooks/use-filtered-font-families.ts");const FontFamilySelector=({fontFamilies:e,fontFamily:t,onFontFamilyChange:r,onClose:s,sectionWidth:i})=>{const[p,d]=(0,o.useState)(""),m=(0,u.useFilteredFontFamilies)(e,p),handleClose=()=>{d(""),s()};return o.createElement(n.PopoverBody,{width:i},o.createElement(n.PopoverHeader,{title:(0,c.__)("Font Family","elementor"),onClose:handleClose,icon:o.createElement(a.TextIcon,{fontSize:"tiny"})}),o.createElement(n.PopoverSearch,{value:p,onSearch:e=>{d(e)},placeholder:(0,c.__)("Search","elementor")}),o.createElement(l.Divider,null),m.length>0?o.createElement(FontList,{fontListItems:m,setFontFamily:r,handleClose:handleClose,fontFamily:t}):o.createElement(l.Stack,{alignItems:"center",justifyContent:"center",height:"100%",p:2.5,gap:1.5,overflow:"hidden"},o.createElement(a.TextIcon,{fontSize:"large"}),o.createElement(l.Box,{sx:{maxWidth:160,overflow:"hidden"}},o.createElement(l.Typography,{align:"center",variant:"subtitle2",color:"text.secondary"},(0,c.__)("Sorry, nothing matched","elementor")),o.createElement(l.Typography,{variant:"subtitle2",color:"text.secondary",sx:{display:"flex",width:"100%",justifyContent:"center"}},o.createElement("span",null,"“"),o.createElement("span",{style:{maxWidth:"80%",overflow:"hidden",textOverflow:"ellipsis"}},p),o.createElement("span",null,"”."))),o.createElement(l.Typography,{align:"center",variant:"caption",color:"text.secondary",sx:{display:"flex",flexDirection:"column"}},(0,c.__)("Try something else.","elementor"),o.createElement(l.Link,{color:"secondary",variant:"caption",component:"button",onClick:()=>d("")},(0,c.__)("Clear & try again","elementor")))))},FontList=({fontListItems:e,setFontFamily:t,handleClose:r,fontFamily:a})=>{const l=e.find(e=>e.value===a),s=useDebounce(({getVirtualIndexes:t})=>{t().forEach(t=>{const r=e[t];r&&"font"===r.type&&(0,i.enqueueFont)(r.value)})},100);return o.createElement(n.PopoverMenuList,{items:e,selectedValue:l?.value,onChange:s,onSelect:t,onClose:r,itemStyle:e=>({fontFamily:e.value}),"data-testid":"font-list"})},useDebounce=(e,t)=>{const[r]=(0,o.useState)(()=>(0,s.debounce)(e,t));return(0,o.useEffect)(()=>()=>r.cancel(),[r]),r}},"./packages/packages/libs/editor-controls/src/components/popover-content.tsx":function(e,t,r){r.r(t),r.d(t,{PopoverContent:function(){return PopoverContent}});var o=r("react"),n=r("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const PopoverContent=({gap:e=1.5,children:t,...r})=>o.createElement(n.Stack,_extends({},r,{gap:e}),t)},"./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx":function(e,t,r){r.r(t),r.d(t,{PopoverGridContainer:function(){return a}});var o=r("react"),n=r("@elementor/ui");const a=(0,o.forwardRef)(({gap:e=1.5,alignItems:t="center",flexWrap:r="nowrap",children:a},l)=>o.createElement(n.Grid,{container:!0,gap:e,alignItems:t,flexWrap:r,ref:l},a))},"./packages/packages/libs/editor-controls/src/components/repeater.tsx":function(e,t,r){r.r(t),r.d(t,{Repeater:function(){return Repeater}});var o=r("react"),n=r("@elementor/icons"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/control-adornments/control-adornments.tsx"),c=r("./packages/packages/libs/editor-controls/src/hooks/use-sync-external-state.tsx"),i=r("./packages/packages/libs/editor-controls/src/locations.ts"),u=r("./packages/packages/libs/editor-controls/src/components/section-content.tsx"),p=r("./packages/packages/libs/editor-controls/src/components/sortable.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const d="tiny",Repeater=({label:e,itemSettings:t,disabled:r=!1,openOnAdd:m=!1,addToBottom:g=!1,values:b=[],setValues:f,showDuplicate:k=!0,showToggle:v=!0,isSortable:x=!0,collectionPropUtil:y})=>{const[E,_]=(0,o.useState)(-1),[h,P]=(0,c.useSyncExternalState)({external:b,setExternal:f,persistWhen:()=>!0}),[C,w]=(0,o.useState)(h.map((e,t)=>t)),generateNextKey=e=>1+Math.max(0,...e);return o.createElement(u.SectionContent,null,o.createElement(a.Stack,{direction:"row",justifyContent:"start",alignItems:"center",gap:1,sx:{marginInlineEnd:-.75}},o.createElement(a.Typography,{component:"label",variant:"caption",color:"text.secondary"},e),o.createElement(s.ControlAdornments,null),o.createElement(a.IconButton,{size:d,sx:{ml:"auto"},disabled:r,onClick:()=>{const e=structuredClone(t.initialValues),r=generateNextKey(C);g?(P([...h,e]),w([...C,r])):(P([e,...h]),w([r,...C])),m&&_(r)},"aria-label":(0,l.__)("Add item","elementor")},o.createElement(n.PlusIcon,{fontSize:d}))),0<C.length&&o.createElement(p.SortableProvider,{value:C,onChange:e=>{w(e),P(t=>e.map(e=>{const r=C.indexOf(e);return t[r]}))}},C.map((e,n)=>{const a=h[n];return a?o.createElement(p.SortableItem,{id:e,key:`sortable-${e}`,disabled:!x},o.createElement(RepeaterItem,{disabled:r,propDisabled:a?.disabled,label:o.createElement(i.RepeaterItemLabelSlot,{value:a},o.createElement(t.Label,{value:a})),startIcon:o.createElement(i.RepeaterItemIconSlot,{value:a},o.createElement(t.Icon,{value:a})),removeItem:()=>(e=>{w(C.filter((t,r)=>r!==e)),P(h.filter((t,r)=>r!==e))})(n),duplicateItem:()=>(e=>{const t=structuredClone(h[e]),r=generateNextKey(C),o=1+e;P([...h.slice(0,o),t,...h.slice(o)]),w([...C.slice(0,o),r,...C.slice(o)])})(n),toggleDisableItem:()=>(e=>{P(h.map((t,r)=>{if(r===e){const{disabled:e,...r}=t;return{...r,...e?{}:{disabled:!0}}}return t}))})(n),openOnMount:m&&E===e,onOpen:()=>_(-1),showDuplicate:k,showToggle:v,collectionPropUtil:y},e=>o.createElement(t.Content,_extends({},e,{value:a,bind:String(n)})))):null})))},RepeaterItem=({label:e,propDisabled:t,startIcon:r,children:s,removeItem:c,duplicateItem:i,toggleDisableItem:u,openOnMount:p,onOpen:m,showDuplicate:g,showToggle:b,disabled:f,collectionPropUtil:k})=>{const[v,x]=(0,o.useState)(null),{popoverState:y,popoverProps:E,ref:_,setRef:h}=usePopover(p,m),P=(0,l.__)("Duplicate","elementor"),C=t?(0,l.__)("Show","elementor"):(0,l.__)("Hide","elementor"),w=(0,l.__)("Remove","elementor");return o.createElement(o.Fragment,null,o.createElement(a.UnstableTag,_extends({disabled:f,label:e,showActionsOnHover:!0,fullWidth:!0,ref:h,variant:"outlined","aria-label":(0,l.__)("Open item","elementor")},(0,a.bindTrigger)(y),{startIcon:r,actions:o.createElement(o.Fragment,null,g&&o.createElement(a.Tooltip,{title:P,placement:"top"},o.createElement(a.IconButton,{size:d,onClick:i,"aria-label":P},o.createElement(n.CopyIcon,{fontSize:d}))),b&&o.createElement(a.Tooltip,{title:C,placement:"top"},o.createElement(a.IconButton,{size:d,onClick:u,"aria-label":C},t?o.createElement(n.EyeOffIcon,{fontSize:d}):o.createElement(n.EyeIcon,{fontSize:d}))),o.createElement(a.Tooltip,{title:w,placement:"top"},o.createElement(a.IconButton,{size:d,onClick:c,"aria-label":w},o.createElement(n.XIcon,{fontSize:d}))))})),o.createElement(a.Popover,_extends({disablePortal:!0,slotProps:{paper:{ref:x,sx:{mt:.5,width:_?.getBoundingClientRect().width}}},anchorOrigin:{vertical:"bottom",horizontal:"left"}},E,{anchorEl:_}),o.createElement(a.Box,null,s({anchorEl:v,collectionPropUtil:k}))))},usePopover=(e,t)=>{const[r,n]=(0,o.useState)(null),l=(0,a.usePopupState)({variant:"popover"}),s=(0,a.bindPopover)(l);return(0,o.useEffect)(()=>{e&&r&&(l.open(r),t?.())},[r]),{popoverState:l,ref:r,setRef:n,popoverProps:s}}},"./packages/packages/libs/editor-controls/src/components/section-content.tsx":function(e,t,r){r.r(t),r.d(t,{SectionContent:function(){return SectionContent}});var o=r("react"),n=r("@elementor/ui");const SectionContent=({gap:e=2,sx:t,children:r})=>o.createElement(n.Stack,{gap:e,sx:{...t}},r)},"./packages/packages/libs/editor-controls/src/components/size-control/size-input.tsx":function(e,t,r){r.r(t),r.d(t,{SizeInput:function(){return SizeInput}});var o=r("react"),n=r("@elementor/icons"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx"),s=r("./packages/packages/libs/editor-controls/src/utils/size-control.ts"),c=r("./packages/packages/libs/editor-controls/src/components/size-control/text-field-inner-selection.tsx");const i=["e","E","+","-"],SizeInput=({units:e,handleUnitChange:t,handleSizeChange:r,placeholder:u,startIcon:p,onBlur:d,onFocus:m,onClick:g,size:b,unit:f,popupState:k,disabled:v})=>{const x=(0,o.useRef)(""),y=(0,s.isUnitExtendedOption)(f)?"text":"number",E=!(0,s.isUnitExtendedOption)(f)&&Number.isNaN(b)?"":b??"",_={"aria-controls":k.isOpen?k.popupId:void 0,"aria-haspopup":!0},h={..._,autoComplete:"off",onClick:g,onFocus:m,startAdornment:p?o.createElement(a.InputAdornment,{position:"start",disabled:v},p):void 0,endAdornment:o.createElement(c.SelectionEndAdornment,{disabled:v,options:e,onClick:t,value:f,alternativeOptionLabels:{custom:o.createElement(n.PencilIcon,{fontSize:"small"})},menuItemsAttributes:e.includes("custom")?{custom:_}:void 0})};return o.createElement(l.default,null,o.createElement(a.Box,null,o.createElement(c.TextFieldInnerSelection,{disabled:v,placeholder:u,type:y,value:E,onChange:r,onKeyDown:e=>{i.includes(e.key)&&e.preventDefault()},onKeyUp:r=>{const{key:o}=r;if(!/^[a-zA-Z%]$/.test(o))return;r.preventDefault();const n=o.toLowerCase(),a=(x.current+n).slice(-3);x.current=a;const l=e.find(e=>e.includes(a))||e.find(e=>e.startsWith(n))||e.find(e=>e.includes(n));l&&t(l)},onBlur:d,shouldBlockInput:(0,s.isUnitExtendedOption)(f),inputProps:h})))}},"./packages/packages/libs/editor-controls/src/components/size-control/text-field-inner-selection.tsx":function(e,t,r){r.r(t),r.d(t,{SelectionEndAdornment:function(){return SelectionEndAdornment},TextFieldInnerSelection:function(){return i}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/editor-ui"),l=r("@elementor/ui"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/utils/size-control.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const i=(0,o.forwardRef)(({placeholder:e,type:t,value:r,onChange:a,onBlur:c,onKeyDown:i,onKeyUp:u,shouldBlockInput:p=!1,inputProps:d,disabled:m},g)=>{const{placeholder:b}=(0,s.useBoundProp)(n.sizePropTypeUtil);return o.createElement(l.TextField,{ref:g,sx:{input:{cursor:p?"default !important":void 0}},size:"tiny",fullWidth:!0,type:p?void 0:t,value:r,onChange:p?void 0:a,onKeyDown:p?void 0:i,onKeyUp:p?void 0:u,disabled:m,onBlur:c,placeholder:e??(String(b?.size??"")||void 0),InputProps:d})}),SelectionEndAdornment=({options:e,alternativeOptionLabels:t={},onClick:r,value:i,menuItemsAttributes:p={},disabled:d})=>{const m=(0,l.usePopupState)({variant:"popover",popupId:(0,o.useId)()}),{placeholder:g,showPrimaryColor:b}=function useUnitPlaceholder(e){const{value:t,placeholder:r}=(0,s.useBoundProp)(n.sizePropTypeUtil),o=t?.size,a=t?.unit,l="custom"===e&&Boolean(o),i="auto"===e,u=i||l||Boolean(o);if(!r)return{placeholder:null,showPrimaryColor:u};const p=!a&&e===c.DEFAULT_UNIT;return{placeholder:p?r.unit:void 0,showPrimaryColor:u}}(i);return o.createElement(l.InputAdornment,{position:"end"},o.createElement(u,_extends({isPrimaryColor:b,size:"small",disabled:d},(0,l.bindTrigger)(m)),g??t[i]??i),o.createElement(l.Menu,_extends({MenuListProps:{dense:!0}},(0,l.bindMenu)(m)),e.map((n,l)=>o.createElement(a.MenuListItem,_extends({key:n,onClick:()=>(t=>{r(e[t]),m.close()})(l)},p?.[n]),t[n]??n.toUpperCase()))))};const u=(0,l.styled)(l.Button,{shouldForwardProp:e=>"isPrimaryColor"!==e})(({isPrimaryColor:e,theme:t})=>({color:e?t.palette.text.primary:t.palette.text.tertiary,font:"inherit",minWidth:"initial",textTransform:"uppercase"}))},"./packages/packages/libs/editor-controls/src/components/sortable.tsx":function(e,t,r){r.r(t),r.d(t,{SortableItem:function(){return SortableItem},SortableProvider:function(){return SortableProvider}});var o=r("react"),n=r("@elementor/icons"),a=r("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const SortableProvider=e=>o.createElement(a.List,{sx:{p:0,my:-.5,mx:0}},o.createElement(a.UnstableSortableProvider,_extends({restrictAxis:!0,disableDragOverlay:!1,variant:"static"},e))),SortableItem=({id:e,children:t,disabled:r})=>o.createElement(a.UnstableSortableItem,{id:e,disabled:r,render:({itemProps:e,triggerProps:n,itemStyle:a,triggerStyle:c,showDropIndication:i,dropIndicationStyle:u})=>o.createElement(l,_extends({},e,{style:a}),!r&&o.createElement(SortableTrigger,_extends({},n,{style:c})),t,i&&o.createElement(s,{style:u}))}),l=(0,a.styled)(a.ListItem)`
	position: relative;
	margin-inline: 0px;
	padding-inline: 0px;
	padding-block: ${({theme:e})=>e.spacing(.5)};

	& .class-item-sortable-trigger {
		color: ${({theme:e})=>e.palette.action.active};
		height: 100%;
		display: flex;
		align-items: center;
		visibility: hidden;
		position: absolute;
		top: 50%;
		padding-inline-end: ${({theme:e})=>e.spacing(.5)};
		transform: translate( -75%, -50% );
	}

	&[aria-describedby=''] > .MuiTag-root {
		background-color: ${({theme:e})=>e.palette.background.paper};
		box-shadow: ${({theme:e})=>e.shadows[3]};
	}

	&:hover {
		& .class-item-sortable-trigger {
			visibility: visible;
		}
	}
`,SortableTrigger=e=>o.createElement("div",_extends({},e,{role:"button",className:"class-item-sortable-trigger"}),o.createElement(n.GripVerticalIcon,{fontSize:"tiny"})),s=(0,a.styled)(a.Divider)`
	height: 0px;
	border: none;
	overflow: visible;

	&:after {
		--height: 2px;
		content: '';
		display: block;
		width: 100%;
		height: var( --height );
		margin-block: calc( -1 * var( --height ) / 2 );
		border-radius: ${({theme:e})=>e.spacing(.5)};
		background-color: ${({theme:e})=>e.palette.text.primary};
	}
`},"./packages/packages/libs/editor-controls/src/components/text-field-popover.tsx":function(e,t,r){r.r(t),r.d(t,{TextFieldPopover:function(){return TextFieldPopover}});var o=r("react"),n=r("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const TextFieldPopover=e=>{const{popupState:t,restoreValue:r,anchorRef:a,value:l,onChange:s}=e;return o.createElement(n.Popover,_extends({disablePortal:!0,slotProps:{paper:{sx:{borderRadius:2,width:a.current?.offsetWidth+"px",p:1.5}}}},(0,n.bindPopover)(t),{anchorOrigin:{vertical:"bottom",horizontal:"center"},transformOrigin:{vertical:"top",horizontal:"center"},onClose:()=>{r(),t.close()}}),o.createElement(n.TextField,{value:l,onChange:s,size:"tiny",type:"text",fullWidth:!0,inputProps:{autoFocus:!0}}))}},"./packages/packages/libs/editor-controls/src/control-actions/control-actions-context.tsx":function(e,t,r){r.r(t),r.d(t,{ControlActionsProvider:function(){return ControlActionsProvider},useControlActions:function(){return useControlActions}});var o=r("react");const n=(0,o.createContext)(null),ControlActionsProvider=({children:e,items:t})=>o.createElement(n.Provider,{value:{items:t}},e),useControlActions=()=>{const e=(0,o.useContext)(n);if(!e)throw new Error("useControlActions must be used within a ControlActionsProvider");return e}},"./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx":function(e,t,r){r.r(t),r.d(t,{default:function(){return ControlActions}});var o=r("react"),n=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),a=r("./packages/packages/libs/editor-controls/src/components/floating-bar.tsx"),l=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions-context.tsx");function ControlActions({children:e}){const{items:t}=(0,l.useControlActions)(),{disabled:r}=(0,n.useBoundProp)();if(0===t.length||r)return e;const s=t.map(({MenuItem:e,id:t})=>o.createElement(e,{key:t}));return o.createElement(a.FloatingActionsBar,{actions:s},e)}},"./packages/packages/libs/editor-controls/src/control-adornments/control-adornments-context.tsx":function(e,t,r){r.r(t),r.d(t,{ControlAdornmentsProvider:function(){return ControlAdornmentsProvider},useControlAdornments:function(){return useControlAdornments}});var o=r("react");const n=(0,o.createContext)(null),ControlAdornmentsProvider=({children:e,items:t})=>o.createElement(n.Provider,{value:{items:t}},e),useControlAdornments=()=>{const e=(0,o.useContext)(n);return e?.items??[]}},"./packages/packages/libs/editor-controls/src/control-adornments/control-adornments.tsx":function(e,t,r){r.r(t),r.d(t,{ControlAdornments:function(){return ControlAdornments}});var o=r("react"),n=r("./packages/packages/libs/editor-controls/src/control-adornments/control-adornments-context.tsx");function ControlAdornments(){const e=(0,n.useControlAdornments)();return 0===e?.length?null:o.createElement(o.Fragment,null,e.map(({Adornment:e,id:t})=>o.createElement(e,{key:t})))}},"./packages/packages/libs/editor-controls/src/control-replacements.tsx":function(e,t,r){r.r(t),r.d(t,{ControlReplacementsProvider:function(){return ControlReplacementsProvider},createControlReplacementsRegistry:function(){return createControlReplacementsRegistry},useControlReplacement:function(){return useControlReplacement}});var o=r("react"),n=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts");const a=(0,o.createContext)([]),ControlReplacementsProvider=({replacements:e,children:t})=>o.createElement(a.Provider,{value:e},t),useControlReplacement=e=>{const{value:t}=(0,n.useBoundProp)(),r=(0,o.useContext)(a);try{const o=r.find(e=>e.condition({value:t}));return o?.component??e}catch{return e}},createControlReplacementsRegistry=()=>{const e=[];return{registerControlReplacement:function registerControlReplacement(t){e.push(t)},getControlReplacements:function getControlReplacements(){return e}}}},"./packages/packages/libs/editor-controls/src/controls/aspect-ratio-control.tsx":function(e,t,r){r.r(t),r.d(t,{AspectRatioControl:function(){return b}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/editor-ui"),l=r("@elementor/icons"),s=r("@elementor/ui"),c=r("@wordpress/i18n"),i=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),u=r("./packages/packages/libs/editor-controls/src/components/control-label.tsx"),p=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx"),d=r("./packages/packages/libs/editor-controls/src/create-control.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const m=[{label:(0,c.__)("Auto","elementor"),value:"auto"},{label:"1/1",value:"1/1"},{label:"4/3",value:"4/3"},{label:"3/4",value:"3/4"},{label:"16/9",value:"16/9"},{label:"9/16",value:"9/16"},{label:"3/2",value:"3/2"},{label:"2/3",value:"2/3"}],g="custom",b=(0,d.createControl)(({label:e})=>{const{value:t,setValue:r,disabled:d}=(0,i.useBoundProp)(n.stringPropTypeUtil),b=t&&!m.some(e=>e.value===t),[f,k]=b?t.split("/"):["",""],[v,x]=(0,o.useState)(b),[y,E]=(0,o.useState)(f),[_,h]=(0,o.useState)(k),[P,C]=(0,o.useState)(b?g:t||"");(0,o.useEffect)(()=>{if(t&&!m.some(e=>e.value===t)){const[e,r]=t.split("/");E(e||""),h(r||""),C(g),x(!0)}else C(t||""),x(!1),E(""),h("")},[t]);return o.createElement(p.default,null,o.createElement(s.Stack,{direction:"column",gap:2},o.createElement(s.Grid,{container:!0,gap:2,alignItems:"center",flexWrap:"nowrap"},o.createElement(s.Grid,{item:!0,xs:6},o.createElement(u.ControlLabel,null,e)),o.createElement(s.Grid,{item:!0,xs:6},o.createElement(s.Select,{size:"tiny",displayEmpty:!0,sx:{overflow:"hidden"},disabled:d,value:P,onChange:e=>{const t=e.target.value,o=t===g;x(o),C(t),o||r(t)},fullWidth:!0},[...m,{label:(0,c.__)("Custom","elementor"),value:g}].map(({label:e,...t})=>o.createElement(a.MenuListItem,_extends({key:t.value},t,{value:t.value??""}),e))))),v&&o.createElement(s.Grid,{container:!0,gap:2,alignItems:"center",flexWrap:"nowrap"},o.createElement(s.Grid,{item:!0,xs:6},o.createElement(s.TextField,{size:"tiny",type:"number",fullWidth:!0,disabled:d,value:y,onChange:e=>{const t=e.target.value;E(t),t&&_&&r(`${t}/${_}`)},InputProps:{startAdornment:o.createElement(l.ArrowsMoveHorizontalIcon,{fontSize:"tiny"})}})),o.createElement(s.Grid,{item:!0,xs:6},o.createElement(s.TextField,{size:"tiny",type:"number",fullWidth:!0,disabled:d,value:_,onChange:e=>{const t=e.target.value;h(t),y&&t&&r(`${y}/${t}`)},InputProps:{startAdornment:o.createElement(l.ArrowsMoveVerticalIcon,{fontSize:"tiny"})}})))))})},"./packages/packages/libs/editor-controls/src/controls/background-control/background-control.tsx":function(e,t,r){r.r(t),r.d(t,{BackgroundControl:function(){return d}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/components/control-label.tsx"),i=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),u=r("./packages/packages/libs/editor-controls/src/controls/color-control.tsx"),p=r("./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/background-overlay-repeater-control.tsx");const d=(0,i.createControl)(()=>{const e=(0,s.useBoundProp)(n.backgroundPropTypeUtil),t=(0,l.__)("Color","elementor");return o.createElement(s.PropProvider,e,o.createElement(s.PropKeyProvider,{bind:"background-overlay"},o.createElement(p.BackgroundOverlayRepeaterControl,null)),o.createElement(s.PropKeyProvider,{bind:"color"},o.createElement(a.Grid,{container:!0,gap:2,alignItems:"center",flexWrap:"nowrap"},o.createElement(a.Grid,{item:!0,xs:6},o.createElement(c.ControlLabel,null,t)),o.createElement(a.Grid,{item:!0,xs:6},o.createElement(u.ColorControl,null)))))})},"./packages/packages/libs/editor-controls/src/controls/background-control/background-gradient-color-control.tsx":function(e,t,r){r.r(t),r.d(t,{BackgroundGradientColorControl:function(){return c},initialBackgroundGradientOverlay:function(){return i}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),s=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx");const c=(0,r("./packages/packages/libs/editor-controls/src/create-control.tsx").createControl)(()=>{const{value:e,setValue:t}=(0,l.useBoundProp)(n.backgroundGradientOverlayPropTypeUtil),createTransformableValue=e=>({...e,type:n.stringPropTypeUtil.create(e.type),angle:n.numberPropTypeUtil.create(e.angle),stops:n.gradientColorStopPropTypeUtil.create(e.stops.map(({color:e,offset:t})=>n.colorStopPropTypeUtil.create({color:n.colorPropTypeUtil.create(e),offset:n.numberPropTypeUtil.create(t)})))});return o.createElement(s.default,null,o.createElement(a.UnstableGradientBox,{sx:{width:"auto",padding:1.5},value:(()=>{if(!e)return;const{type:t,angle:r,stops:o,positions:n}=e;return{type:t.value,angle:r.value,stops:o.value.map(({value:{color:e,offset:t}})=>({color:e.value,offset:t.value})),positions:n?.value.split(" ")}})(),onChange:e=>{const r=createTransformableValue(e);r.positions&&(r.positions=n.stringPropTypeUtil.create(e.positions.join(" "))),t(r)}}))}),i=n.backgroundGradientOverlayPropTypeUtil.create({type:n.stringPropTypeUtil.create("linear"),angle:n.numberPropTypeUtil.create(180),stops:n.gradientColorStopPropTypeUtil.create([n.colorStopPropTypeUtil.create({color:n.colorPropTypeUtil.create("rgb(0,0,0)"),offset:n.numberPropTypeUtil.create(0)}),n.colorStopPropTypeUtil.create({color:n.colorPropTypeUtil.create("rgb(255,255,255)"),offset:n.numberPropTypeUtil.create(100)})])})},"./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/background-image-overlay/background-image-overlay-attachment.tsx":function(e,t,r){r.r(t),r.d(t,{BackgroundImageOverlayAttachment:function(){return BackgroundImageOverlayAttachment}});var o=r("react"),n=r("@elementor/icons"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),c=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),i=r("./packages/packages/libs/editor-controls/src/controls/toggle-control.tsx");const u=[{value:"fixed",label:(0,l.__)("Fixed","elementor"),renderContent:({size:e})=>o.createElement(n.PinIcon,{fontSize:e}),showTooltip:!0},{value:"scroll",label:(0,l.__)("Scroll","elementor"),renderContent:({size:e})=>o.createElement(n.PinnedOffIcon,{fontSize:e}),showTooltip:!0}],BackgroundImageOverlayAttachment=()=>o.createElement(c.PopoverGridContainer,null,o.createElement(a.Grid,{item:!0,xs:6},o.createElement(s.ControlFormLabel,null,(0,l.__)("Attachment","elementor"))),o.createElement(a.Grid,{item:!0,xs:6,sx:{display:"flex",justifyContent:"flex-end",overflow:"hidden"}},o.createElement(i.ToggleControl,{options:u})))},"./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/background-image-overlay/background-image-overlay-position.tsx":function(e,t,r){r.r(t),r.d(t,{BackgroundImageOverlayPosition:function(){return BackgroundImageOverlayPosition}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/editor-ui"),l=r("@elementor/icons"),s=r("@elementor/ui"),c=r("@wordpress/i18n"),i=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),u=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),p=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),d=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");const m=[{label:(0,c.__)("Center center","elementor"),value:"center center"},{label:(0,c.__)("Center left","elementor"),value:"center left"},{label:(0,c.__)("Center right","elementor"),value:"center right"},{label:(0,c.__)("Top center","elementor"),value:"top center"},{label:(0,c.__)("Top left","elementor"),value:"top left"},{label:(0,c.__)("Top right","elementor"),value:"top right"},{label:(0,c.__)("Bottom center","elementor"),value:"bottom center"},{label:(0,c.__)("Bottom left","elementor"),value:"bottom left"},{label:(0,c.__)("Bottom right","elementor"),value:"bottom right"},{label:(0,c.__)("Custom","elementor"),value:"custom"}],BackgroundImageOverlayPosition=()=>{const e=(0,i.useBoundProp)(n.backgroundImagePositionOffsetPropTypeUtil),t=(0,i.useBoundProp)(n.stringPropTypeUtil),r=!!e.value,g=(0,o.useRef)(null);return o.createElement(s.Grid,{container:!0,spacing:1.5},o.createElement(s.Grid,{item:!0,xs:12},o.createElement(p.PopoverGridContainer,null,o.createElement(s.Grid,{item:!0,xs:6},o.createElement(u.ControlFormLabel,null,(0,c.__)("Position","elementor"))),o.createElement(s.Grid,{item:!0,xs:6,sx:{display:"flex",justifyContent:"flex-end",overflow:"hidden"}},o.createElement(s.Select,{fullWidth:!0,size:"tiny",onChange:r=>{const o=r.target.value||null;"custom"===o?e.setValue({x:null,y:null}):t.setValue(o)},disabled:t.disabled,value:(e.value?"custom":t.value)??""},m.map(({label:e,value:t})=>o.createElement(a.MenuListItem,{key:t,value:t??""},e)))))),r?o.createElement(i.PropProvider,e,o.createElement(s.Grid,{item:!0,xs:12},o.createElement(s.Grid,{container:!0,spacing:1.5,ref:g},o.createElement(s.Grid,{item:!0,xs:6},o.createElement(i.PropKeyProvider,{bind:"x"},o.createElement(d.SizeControl,{startIcon:o.createElement(l.LetterXIcon,{fontSize:"tiny"}),anchorRef:g}))),o.createElement(s.Grid,{item:!0,xs:6},o.createElement(i.PropKeyProvider,{bind:"y"},o.createElement(d.SizeControl,{startIcon:o.createElement(l.LetterYIcon,{fontSize:"tiny"}),anchorRef:g})))))):null)}},"./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/background-image-overlay/background-image-overlay-repeat.tsx":function(e,t,r){r.r(t),r.d(t,{BackgroundImageOverlayRepeat:function(){return BackgroundImageOverlayRepeat}});var o=r("react"),n=r("@elementor/icons"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),c=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),i=r("./packages/packages/libs/editor-controls/src/controls/toggle-control.tsx");const u=[{value:"repeat",label:(0,l.__)("Repeat","elementor"),renderContent:({size:e})=>o.createElement(n.GridDotsIcon,{fontSize:e}),showTooltip:!0},{value:"repeat-x",label:(0,l.__)("Repeat-x","elementor"),renderContent:({size:e})=>o.createElement(n.DotsHorizontalIcon,{fontSize:e}),showTooltip:!0},{value:"repeat-y",label:(0,l.__)("Repeat-y","elementor"),renderContent:({size:e})=>o.createElement(n.DotsVerticalIcon,{fontSize:e}),showTooltip:!0},{value:"no-repeat",label:(0,l.__)("No-repeat","elementor"),renderContent:({size:e})=>o.createElement(n.XIcon,{fontSize:e}),showTooltip:!0}],BackgroundImageOverlayRepeat=()=>o.createElement(c.PopoverGridContainer,null,o.createElement(a.Grid,{item:!0,xs:6},o.createElement(s.ControlFormLabel,null,(0,l.__)("Repeat","elementor"))),o.createElement(a.Grid,{item:!0,xs:6,sx:{display:"flex",justifyContent:"flex-end"}},o.createElement(i.ToggleControl,{options:u})))},"./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/background-image-overlay/background-image-overlay-size.tsx":function(e,t,r){r.r(t),r.d(t,{BackgroundImageOverlaySize:function(){return BackgroundImageOverlaySize}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("@wordpress/i18n"),c=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),i=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),u=r("./packages/packages/libs/editor-controls/src/components/control-toggle-button-group.tsx"),p=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),d=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");const m=[{value:"auto",label:(0,s.__)("Auto","elementor"),renderContent:({size:e})=>o.createElement(a.LetterAIcon,{fontSize:e}),showTooltip:!0},{value:"cover",label:(0,s.__)("Cover","elementor"),renderContent:({size:e})=>o.createElement(a.ArrowsMaximizeIcon,{fontSize:e}),showTooltip:!0},{value:"contain",label:(0,s.__)("Contain","elementor"),renderContent:({size:e})=>o.createElement(a.ArrowBarBothIcon,{fontSize:e}),showTooltip:!0},{value:"custom",label:(0,s.__)("Custom","elementor"),renderContent:({size:e})=>o.createElement(a.PencilIcon,{fontSize:e}),showTooltip:!0}],BackgroundImageOverlaySize=()=>{const e=(0,c.useBoundProp)(n.backgroundImageSizeScalePropTypeUtil),t=(0,c.useBoundProp)(n.stringPropTypeUtil),r=!!e.value,g=(0,o.useRef)(null);return o.createElement(l.Grid,{container:!0,spacing:1.5},o.createElement(l.Grid,{item:!0,xs:12},o.createElement(p.PopoverGridContainer,null,o.createElement(l.Grid,{item:!0,xs:6},o.createElement(i.ControlFormLabel,null,(0,s.__)("Size","elementor"))),o.createElement(l.Grid,{item:!0,xs:6,sx:{display:"flex",justifyContent:"flex-end"}},o.createElement(u.ControlToggleButtonGroup,{exclusive:!0,items:m,onChange:r=>{"custom"===r?e.setValue({width:null,height:null}):t.setValue(r)},disabled:t.disabled,value:e.value?"custom":t.value})))),r?o.createElement(c.PropProvider,e,o.createElement(l.Grid,{item:!0,xs:12,ref:g},o.createElement(p.PopoverGridContainer,null,o.createElement(l.Grid,{item:!0,xs:6},o.createElement(c.PropKeyProvider,{bind:"width"},o.createElement(d.SizeControl,{startIcon:o.createElement(a.ArrowsMoveHorizontalIcon,{fontSize:"tiny"}),extendedOptions:["auto"],anchorRef:g}))),o.createElement(l.Grid,{item:!0,xs:6},o.createElement(c.PropKeyProvider,{bind:"height"},o.createElement(d.SizeControl,{startIcon:o.createElement(a.ArrowsMoveVerticalIcon,{fontSize:"tiny"}),extendedOptions:["auto"],anchorRef:g})))))):null)}},"./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/background-overlay-repeater-control.tsx":function(e,t,r){r.r(t),r.d(t,{BackgroundOverlayRepeaterControl:function(){return h},ItemContent:function(){return ItemContent},getInitialBackgroundOverlay:function(){return getInitialBackgroundOverlay},initialBackgroundColorOverlay:function(){return E}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("@elementor/wp-media"),s=r("@wordpress/i18n"),c=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),i=r("./packages/packages/libs/editor-controls/src/components/popover-content.tsx"),u=r("./packages/packages/libs/editor-controls/src/components/repeater.tsx"),p=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),d=r("./packages/packages/libs/editor-controls/src/env.ts"),m=r("./packages/packages/libs/editor-controls/src/controls/color-control.tsx"),g=r("./packages/packages/libs/editor-controls/src/controls/image-control.tsx"),b=r("./packages/packages/libs/editor-controls/src/controls/background-control/background-gradient-color-control.tsx"),f=r("./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/background-image-overlay/background-image-overlay-attachment.tsx"),k=r("./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/background-image-overlay/background-image-overlay-position.tsx"),v=r("./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/background-image-overlay/background-image-overlay-repeat.tsx"),x=r("./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/background-image-overlay/background-image-overlay-size.tsx"),y=r("./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/use-background-tabs-history.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const E=n.backgroundColorOverlayPropTypeUtil.create({color:n.colorPropTypeUtil.create("#00000033")}),getInitialBackgroundOverlay=()=>({$$type:"background-image-overlay",value:{image:{$$type:"image",value:{src:{$$type:"image-src",value:{url:{$$type:"url",value:d.env.background_placeholder_image},id:null}},size:{$$type:"string",value:"large"}}}}}),_=[{label:(0,s.__)("Thumbnail - 150 x 150","elementor"),value:"thumbnail"},{label:(0,s.__)("Medium - 300 x 300","elementor"),value:"medium"},{label:(0,s.__)("Large 1024 x 1024","elementor"),value:"large"},{label:(0,s.__)("Full","elementor"),value:"full"}],h=(0,p.createControl)(()=>{const{propType:e,value:t,setValue:r,disabled:a}=(0,c.useBoundProp)(n.backgroundOverlayPropTypeUtil);return o.createElement(c.PropProvider,{propType:e,value:t,setValue:r,isDisabled:()=>a},o.createElement(u.Repeater,{openOnAdd:!0,disabled:a,values:t??[],setValues:r,label:(0,s.__)("Overlay","elementor"),itemSettings:{Icon:ItemIcon,Label:ItemLabel,Content:ItemContent,initialValues:getInitialBackgroundOverlay()}}))}),ItemContent=({anchorEl:e=null,bind:t})=>o.createElement(c.PropKeyProvider,{bind:t},o.createElement(Content,{anchorEl:e})),Content=({anchorEl:e})=>{const{getTabsProps:t,getTabProps:r,getTabPanelProps:n}=(0,y.useBackgroundTabsHistory)({image:getInitialBackgroundOverlay().value,color:E.value,gradient:b.initialBackgroundGradientOverlay.value});return o.createElement(a.Box,{sx:{width:"100%"}},o.createElement(a.Box,{sx:{borderBottom:1,borderColor:"divider"}},o.createElement(a.Tabs,_extends({size:"small",variant:"fullWidth"},t(),{"aria-label":(0,s.__)("Background Overlay","elementor")}),o.createElement(a.Tab,_extends({label:(0,s.__)("Image","elementor")},r("image"))),o.createElement(a.Tab,_extends({label:(0,s.__)("Gradient","elementor")},r("gradient"))),o.createElement(a.Tab,_extends({label:(0,s.__)("Color","elementor")},r("color"))))),o.createElement(a.TabPanel,_extends({sx:{p:1.5}},n("image")),o.createElement(i.PopoverContent,null,o.createElement(ImageOverlayContent,null))),o.createElement(a.TabPanel,_extends({sx:{p:1.5}},n("gradient")),o.createElement(b.BackgroundGradientColorControl,null)),o.createElement(a.TabPanel,_extends({sx:{p:1.5}},n("color")),o.createElement(i.PopoverContent,null,o.createElement(ColorOverlayContent,{anchorEl:e}))))},ItemIcon=({value:e})=>{switch(e.$$type){case"background-image-overlay":return o.createElement(ItemIconImage,{value:e});case"background-color-overlay":return o.createElement(ItemIconColor,{value:e});case"background-gradient-overlay":return o.createElement(ItemIconGradient,{value:e});default:return null}},extractColorFrom=e=>e?.value?.color?.value?e.value.color.value:"",ItemIconColor=({value:e})=>{const t=extractColorFrom(e);return o.createElement(P,{size:"inherit",component:"span",value:t})},ItemIconImage=({value:e})=>{const{imageUrl:t}=useImage(e);return o.createElement(a.CardMedia,{image:t,sx:e=>({height:"1em",width:"1em",borderRadius:e.shape.borderRadius/2+"px",outline:`1px solid ${e.palette.action.disabled}`})})},ItemIconGradient=({value:e})=>{const t=getGradientValue(e);return o.createElement(P,{size:"inherit",component:"span",value:t})},ItemLabel=({value:e})=>{switch(e.$$type){case"background-image-overlay":return o.createElement(ItemLabelImage,{value:e});case"background-color-overlay":return o.createElement(ItemLabelColor,{value:e});case"background-gradient-overlay":return o.createElement(ItemLabelGradient,{value:e});default:return null}},ItemLabelColor=({value:e})=>{const t=extractColorFrom(e);return o.createElement("span",null,t)},ItemLabelImage=({value:e})=>{const{imageTitle:t}=useImage(e);return o.createElement("span",null,t)},ItemLabelGradient=({value:e})=>"linear"===e.value.type.value?o.createElement("span",null,(0,s.__)("Linear Gradient","elementor")):o.createElement("span",null,(0,s.__)("Radial Gradient","elementor")),ColorOverlayContent=({anchorEl:e})=>{const t=(0,c.useBoundProp)(n.backgroundColorOverlayPropTypeUtil);return o.createElement(c.PropProvider,t,o.createElement(c.PropKeyProvider,{bind:"color"},o.createElement(m.ColorControl,{anchorEl:e})))},ImageOverlayContent=()=>{const e=(0,c.useBoundProp)(n.backgroundImageOverlayPropTypeUtil);return o.createElement(c.PropProvider,e,o.createElement(c.PropKeyProvider,{bind:"image"},o.createElement(g.ImageControl,{sizes:_})),o.createElement(c.PropKeyProvider,{bind:"position"},o.createElement(k.BackgroundImageOverlayPosition,null)),o.createElement(c.PropKeyProvider,{bind:"repeat"},o.createElement(v.BackgroundImageOverlayRepeat,null)),o.createElement(c.PropKeyProvider,{bind:"size"},o.createElement(x.BackgroundImageOverlaySize,null)),o.createElement(c.PropKeyProvider,{bind:"attachment"},o.createElement(f.BackgroundImageOverlayAttachment,null)))},P=(0,a.styled)(a.UnstableColorIndicator)(({theme:e})=>({borderRadius:e.shape.borderRadius/2+"px"})),useImage=e=>{let t,r=null;const o=e?.value.image.value?.src.value,{data:n}=(0,l.useWpMediaAttachment)(o.id?.value||null);if(o.id){const e=getFileExtensionFromFilename(n?.filename);t=`${n?.title}${e}`||null,r=n?.url||null}else o.url&&(r=o.url.value,t=r?.substring(r.lastIndexOf("/")+1)||null);return{imageTitle:t,imageUrl:r}},getFileExtensionFromFilename=e=>{if(!e)return"";return`.${e.substring(e.lastIndexOf(".")+1)}`},getGradientValue=e=>{const t=e.value,r=t.stops.value?.map(({value:{color:e,offset:t}})=>`${e.value} ${t.value??0}%`)?.join(",");return"linear"===t.type.value?`linear-gradient(${t.angle.value}deg, ${r})`:`radial-gradient(circle at ${t.positions.value}, ${r})`}},"./packages/packages/libs/editor-controls/src/controls/background-control/background-overlay/use-background-tabs-history.ts":function(e,t,r){r.r(t),r.d(t,{useBackgroundTabsHistory:function(){return useBackgroundTabsHistory}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts");const useBackgroundTabsHistory=({color:e,image:t,gradient:r})=>{const{value:s,setValue:c}=(0,l.useBoundProp)(n.backgroundImageOverlayPropTypeUtil),{value:i,setValue:u}=(0,l.useBoundProp)(n.backgroundColorOverlayPropTypeUtil),{value:p,setValue:d}=(0,l.useBoundProp)(n.backgroundGradientOverlayPropTypeUtil),{getTabsProps:m,getTabProps:g,getTabPanelProps:b}=(0,a.useTabs)(i?"color":p?"gradient":"image"),f=(0,o.useRef)({image:t,color:e,gradient:r}),saveToHistory=(e,t)=>{t&&(f.current[e]=t)},onTabChange=(e,t)=>{switch(t){case"image":c(f.current.image),saveToHistory("color",i),saveToHistory("gradient",p);break;case"gradient":d(f.current.gradient),saveToHistory("color",i),saveToHistory("image",s);break;case"color":u(f.current.color),saveToHistory("image",s),saveToHistory("gradient",p)}return m().onChange(e,t)};return{getTabProps:g,getTabPanelProps:b,getTabsProps:()=>({...m(),onChange:onTabChange})}}},"./packages/packages/libs/editor-controls/src/controls/box-shadow-repeater-control.tsx":function(e,t,r){r.r(t),r.d(t,{BoxShadowRepeaterControl:function(){return b}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/components/popover-content.tsx"),i=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),u=r("./packages/packages/libs/editor-controls/src/components/repeater.tsx"),p=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),d=r("./packages/packages/libs/editor-controls/src/controls/color-control.tsx"),m=r("./packages/packages/libs/editor-controls/src/controls/select-control.tsx"),g=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");const b=(0,p.createControl)(()=>{const{propType:e,value:t,setValue:r,disabled:a}=(0,s.useBoundProp)(n.boxShadowPropTypeUtil);return o.createElement(s.PropProvider,{propType:e,value:t,setValue:r,isDisabled:()=>a},o.createElement(u.Repeater,{openOnAdd:!0,disabled:a,values:t??[],setValues:r,label:(0,l.__)("Box shadow","elementor"),itemSettings:{Icon:ItemIcon,Label:ItemLabel,Content:ItemContent,initialValues:f}}))}),ItemIcon=({value:e})=>o.createElement(a.UnstableColorIndicator,{size:"inherit",component:"span",value:e.value.color?.value}),ItemContent=({anchorEl:e,bind:t})=>o.createElement(s.PropKeyProvider,{bind:t},o.createElement(Content,{anchorEl:e})),Content=({anchorEl:e})=>{const t=(0,s.useBoundProp)(n.shadowPropTypeUtil),r=[(0,o.useRef)(null),(0,o.useRef)(null)];return o.createElement(s.PropProvider,t,o.createElement(c.PopoverContent,{p:1.5},o.createElement(i.PopoverGridContainer,null,o.createElement(Control,{bind:"color",label:(0,l.__)("Color","elementor")},o.createElement(d.ColorControl,{anchorEl:e})),o.createElement(Control,{bind:"position",label:(0,l.__)("Position","elementor"),sx:{overflow:"hidden"}},o.createElement(m.SelectControl,{options:[{label:(0,l.__)("Inset","elementor"),value:"inset"},{label:(0,l.__)("Outset","elementor"),value:null}]}))),o.createElement(i.PopoverGridContainer,{ref:r[0]},o.createElement(Control,{bind:"hOffset",label:(0,l.__)("Horizontal","elementor")},o.createElement(g.SizeControl,{anchorRef:r[0]})),o.createElement(Control,{bind:"vOffset",label:(0,l.__)("Vertical","elementor")},o.createElement(g.SizeControl,{anchorRef:r[0]}))),o.createElement(i.PopoverGridContainer,{ref:r[1]},o.createElement(Control,{bind:"blur",label:(0,l.__)("Blur","elementor")},o.createElement(g.SizeControl,{anchorRef:r[1]})),o.createElement(Control,{bind:"spread",label:(0,l.__)("Spread","elementor")},o.createElement(g.SizeControl,{anchorRef:r[1]})))))},Control=({label:e,bind:t,children:r,sx:n})=>o.createElement(s.PropKeyProvider,{bind:t},o.createElement(a.Grid,{item:!0,xs:6,sx:n},o.createElement(a.Grid,{container:!0,gap:.75,alignItems:"center"},o.createElement(a.Grid,{item:!0,xs:12},o.createElement(a.FormLabel,{size:"tiny"},e)),o.createElement(a.Grid,{item:!0,xs:12},r)))),ItemLabel=({value:e})=>{const{position:t,hOffset:r,vOffset:n,blur:a,spread:l}=e.value,{size:s="",unit:c=""}=a?.value||{},{size:i="",unit:u=""}=l?.value||{},{size:p="unset",unit:d=""}=r?.value||{},{size:m="unset",unit:g=""}=n?.value||{},b=t?.value||"outset",f=[p+d,m+g,s+c,i+u].join(" ");return o.createElement("span",{style:{textTransform:"capitalize"}},b,": ",f)},f={$$type:"shadow",value:{hOffset:{$$type:"size",value:{unit:"px",size:0}},vOffset:{$$type:"size",value:{unit:"px",size:0}},blur:{$$type:"size",value:{unit:"px",size:10}},spread:{$$type:"size",value:{unit:"px",size:0}},color:{$$type:"color",value:"rgba(0, 0, 0, 1)"},position:null}}},"./packages/packages/libs/editor-controls/src/controls/color-control.tsx":function(e,t,r){r.r(t),r.d(t,{ColorControl:function(){return c}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),s=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const c=(0,r("./packages/packages/libs/editor-controls/src/create-control.tsx").createControl)(({propTypeUtil:e=n.colorPropTypeUtil,anchorEl:t,slotProps:r={},...c})=>{const{value:i,setValue:u,placeholder:p,disabled:d}=(0,l.useBoundProp)(e),m=c.placeholder??p;return o.createElement(s.default,null,o.createElement(a.UnstableColorField,_extends({size:"tiny",fullWidth:!0,value:i??"",placeholder:m??"",onChange:e=>{u(e||null)}},c,{disabled:d,slotProps:{...r,colorPicker:{anchorEl:t,anchorOrigin:{vertical:"top",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:-10},slotProps:{colorIndicator:{value:i??m??""},colorBox:{value:i??m??""}}}}})))})},"./packages/packages/libs/editor-controls/src/controls/equal-unequal-sizes-control.tsx":function(e,t,r){r.r(t),r.d(t,{EqualUnequalSizesControl:function(){return EqualUnequalSizesControl}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),i=r("./packages/packages/libs/editor-controls/src/components/control-label.tsx"),u=r("./packages/packages/libs/editor-controls/src/components/popover-content.tsx"),p=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),d=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const isEqualSizes=(e,t)=>{const r=Object.values(e);if(r.length!==t.length)return!1;const[o,...n]=r;return n.every(e=>e?.value?.size===o?.value?.size&&e?.value?.unit===o?.value?.unit)};function EqualUnequalSizesControl({label:e,icon:t,tooltipLabel:r,items:m,multiSizePropTypeUtil:g}){const b=(0,o.useId)(),f=(0,a.usePopupState)({variant:"popover",popupId:b}),{propType:k,value:v,setValue:x,disabled:y}=(0,s.useBoundProp)(g),{value:E,setValue:_}=(0,s.useBoundProp)(n.sizePropTypeUtil),h=[(0,o.useRef)(null),(0,o.useRef)(null)],splitEqualValue=()=>E?m.reduce((e,{bind:t})=>({...e,[t]:n.sizePropTypeUtil.create(E)}),{}):null,P=!f.isOpen,C=!!v;return o.createElement(o.Fragment,null,o.createElement(a.Grid,{container:!0,gap:2,alignItems:"center",flexWrap:"nowrap",ref:h[0]},o.createElement(a.Grid,{item:!0,xs:6},P?o.createElement(i.ControlLabel,null,e):o.createElement(c.ControlFormLabel,null,e)),o.createElement(a.Grid,{item:!0,xs:6},o.createElement(a.Stack,{direction:"row",alignItems:"center",gap:1},o.createElement(d.SizeControl,{placeholder:C?(0,l.__)("Mixed","elementor"):void 0,anchorRef:h[0]}),o.createElement(a.Tooltip,{title:r,placement:"top"},o.createElement(a.ToggleButton,_extends({size:"tiny",value:"check",sx:{marginLeft:"auto"}},(0,a.bindToggle)(f),{selected:f.isOpen,"aria-label":r}),t))))),o.createElement(a.Popover,_extends({disablePortal:!0,disableScrollLock:!0,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"}},(0,a.bindPopover)(f),{slotProps:{paper:{sx:{mt:.5,width:h[0].current?.getBoundingClientRect().width}}}}),o.createElement(s.PropProvider,{propType:k,value:v||(splitEqualValue()??null),setValue:e=>{const t={...v??splitEqualValue(),...e};if(isEqualSizes(t,m))return _(Object.values(t)[0]?.value);x(t)},isDisabled:()=>y},o.createElement(u.PopoverContent,{p:1.5},o.createElement(p.PopoverGridContainer,{ref:h[1]},o.createElement(MultiSizeValueControl,{item:m[0],rowRef:h[1]}),o.createElement(MultiSizeValueControl,{item:m[1],rowRef:h[1]})),o.createElement(p.PopoverGridContainer,{ref:h[2]},o.createElement(MultiSizeValueControl,{item:m[2],rowRef:h[2]}),o.createElement(MultiSizeValueControl,{item:m[3],rowRef:h[2]}))))))}const MultiSizeValueControl=({item:e,rowRef:t})=>o.createElement(s.PropKeyProvider,{bind:e.bind},o.createElement(a.Grid,{item:!0,xs:6},o.createElement(a.Grid,{container:!0,gap:.75,alignItems:"center"},o.createElement(a.Grid,{item:!0,xs:12},o.createElement(i.ControlLabel,null,e.label)),o.createElement(a.Grid,{item:!0,xs:12},o.createElement(d.SizeControl,{startIcon:e.icon,anchorRef:t})))))},"./packages/packages/libs/editor-controls/src/controls/filter-control/drop-shadow-item-content.tsx":function(e,t,r){r.r(t),r.d(t,{DropShadowItemContent:function(){return DropShadowItemContent}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),i=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),u=r("./packages/packages/libs/editor-controls/src/controls/color-control.tsx"),p=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");const d=[{bind:"xAxis",label:(0,l.__)("X-axis","elementor"),rowIndex:0},{bind:"yAxis",label:(0,l.__)("Y-axis","elementor"),rowIndex:0},{bind:"blur",label:(0,l.__)("Blur","elementor"),rowIndex:1},{bind:"color",label:(0,l.__)("Color","elementor"),rowIndex:1}],DropShadowItemContent=({units:e,anchorEl:t})=>{const r=(0,s.useBoundProp)(n.dropShadowFilterPropTypeUtil),l=[(0,o.useRef)(null),(0,o.useRef)(null)];return o.createElement(s.PropProvider,r,d.map(r=>o.createElement(i.PopoverGridContainer,{key:r.bind,ref:l[r.rowIndex]??null},o.createElement(s.PropKeyProvider,{bind:r.bind},o.createElement(a.Grid,{item:!0,xs:6},o.createElement(c.ControlFormLabel,null,r.label)),o.createElement(a.Grid,{item:!0,xs:6},"color"===r.bind?o.createElement(u.ColorControl,{anchorEl:t}):o.createElement(p.SizeControl,{anchorRef:l[r.rowIndex],units:e,defaultUnit:"px"}))))))}},"./packages/packages/libs/editor-controls/src/controls/filter-control/drop-shadow-item-label.tsx":function(e,t,r){r.r(t),r.d(t,{DropShadowItemLabel:function(){return DropShadowItemLabel}});var o=r("react"),n=r("@elementor/ui");const DropShadowItemLabel=({value:e})=>{const{xAxis:t,yAxis:r,blur:a}=e.value.args.value,l=`${t?.value?.size??0}${t?.value?.unit??"px"}`,s=`${r?.value?.size??0}${r?.value?.unit??"px"}`,c=`${a?.value?.size??10}${a?.value?.unit??"px"}`;return o.createElement(n.Box,{component:"span"},o.createElement(n.Box,{component:"span",style:{textTransform:"capitalize"}},"Drop shadow:"),`${l} ${s} ${c}`)}},"./packages/packages/libs/editor-controls/src/controls/filter-repeater-control.tsx":function(e,t,r){r.r(t),r.d(t,{FilterRepeaterControl:function(){return E}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),i=r("./packages/packages/libs/editor-controls/src/components/popover-content.tsx"),u=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),p=r("./packages/packages/libs/editor-controls/src/components/repeater.tsx"),d=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),m=r("./packages/packages/libs/editor-controls/src/utils/size-control.ts"),g=r("./packages/packages/libs/editor-controls/src/controls/filter-control/drop-shadow-item-content.tsx"),b=r("./packages/packages/libs/editor-controls/src/controls/filter-control/drop-shadow-item-label.tsx"),f=r("./packages/packages/libs/editor-controls/src/controls/select-control.tsx"),k=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const v="blur",x={blur:{defaultValue:{$$type:"css-filter-func",value:{func:{$$type:"string",value:"blur"},args:{$$type:"size",value:{size:0,unit:"px"}}}},name:(0,l.__)("Blur","elementor"),valueName:(0,l.__)("Radius","elementor"),units:m.lengthUnits.filter(e=>"%"!==e)},brightness:{defaultValue:{$$type:"css-filter-func",value:{func:{$$type:"string",value:"brightness"},args:{$$type:"size",value:{size:100,unit:"%"}}}},name:(0,l.__)("Brightness","elementor"),valueName:(0,l.__)("Amount","elementor"),units:["%"]},contrast:{defaultValue:{$$type:"css-filter-func",value:{func:{$$type:"string",value:"contrast"},args:{$$type:"size",value:{size:100,unit:"%"}}}},name:(0,l.__)("Contrast","elementor"),valueName:(0,l.__)("Amount","elementor"),units:["%"]},"hue-rotate":{defaultValue:{$$type:"css-filter-func",value:{func:{$$type:"string",value:"hue-rotate"},args:{$$type:"size",value:{size:0,unit:"deg"}}}},name:(0,l.__)("Hue Rotate","elementor"),valueName:(0,l.__)("Angle","elementor"),units:["deg","rad","grad","turn"]},saturate:{defaultValue:{$$type:"css-filter-func",value:{func:{$$type:"string",value:"saturate"},args:{$$type:"size",value:{size:100,unit:"%"}}}},name:(0,l.__)("Saturate","elementor"),valueName:(0,l.__)("Amount","elementor"),units:["%"]},grayscale:{defaultValue:{$$type:"css-filter-func",value:{func:{$$type:"string",value:"grayscale"},args:{$$type:"size",value:{size:0,unit:"%"}}}},name:(0,l.__)("Grayscale","elementor"),valueName:(0,l.__)("Amount","elementor"),units:["%"]},invert:{defaultValue:{$$type:"css-filter-func",value:{func:{$$type:"string",value:"invert"},args:{$$type:"size",value:{size:0,unit:"%"}}}},name:(0,l.__)("Invert","elementor"),valueName:(0,l.__)("Amount","elementor"),units:["%"]},sepia:{defaultValue:{$$type:"css-filter-func",value:{func:{$$type:"string",value:"sepia"},args:{$$type:"size",value:{size:0,unit:"%"}}}},name:(0,l.__)("Sepia","elementor"),valueName:(0,l.__)("Amount","elementor"),units:["%"]},"drop-shadow":{defaultValue:{$$type:"css-filter-func",value:{func:{$$type:"string",value:"drop-shadow"},args:{$$type:"drop-shadow",value:{xAxis:{$$type:"size",value:{size:0,unit:"px"}},yAxis:{$$type:"size",value:{size:0,unit:"px"}},blur:{$$type:"size",value:{size:10,unit:"px"}},color:{$$type:"color",value:"rgba(0, 0, 0, 1)"}}}}},name:(0,l.__)("Drop shadow","elementor"),valueName:(0,l.__)("Drop-shadow","elementor"),units:m.lengthUnits.filter(e=>"%"!==e)}},y=Object.keys(x),isSingleSize=e=>!["drop-shadow"].includes(e),E=(0,d.createControl)(({filterPropName:e="filter"})=>{const[t,r]="backdrop-filter"===e?[n.backdropFilterPropTypeUtil,(0,l.__)("Backdrop Filters","elementor")]:[n.filterPropTypeUtil,(0,l.__)("Filters","elementor")],{propType:a,value:c,setValue:i,disabled:u}=(0,s.useBoundProp)(t);return o.createElement(s.PropProvider,{propType:a,value:c,setValue:i},o.createElement(p.Repeater,{openOnAdd:!0,disabled:u,values:c??[],setValues:i,label:r,collectionPropUtil:t,itemSettings:{Icon:ItemIcon,Label:ItemLabel,Content:ItemContent,initialValues:x[v].defaultValue}}))}),ItemIcon=()=>o.createElement(o.Fragment,null),ItemLabel=({value:e})=>isSingleSize(e.value.func.value??"")?o.createElement(SingleSizeItemLabel,{value:e}):o.createElement(b.DropShadowItemLabel,{value:e}),SingleSizeItemLabel=({value:e})=>{const{func:t,args:r}=e.value,n=x[t.value??""].defaultValue.value.args.value.unit??m.lengthUnits[0],{unit:l,size:s}=r.value??{unit:n,size:0},c=o.createElement(a.Box,{component:"span",style:{textTransform:"capitalize"}},t.value??"",":");return o.createElement(a.Box,{component:"span"},c,"custom"!==l?` ${s??0}${l??n}`:s)},ItemContent=({bind:e,collectionPropUtil:t,anchorEl:r})=>{const{value:a=[]}=(0,s.useBoundProp)(t??n.filterPropTypeUtil),l=parseInt(e,10),c=a?.[l];return c?o.createElement(s.PropKeyProvider,{bind:e},o.createElement(PropContent,{item:c,anchorEl:r})):null},PropContent=({item:e,anchorEl:t})=>{const r=(0,s.useBoundProp)(n.cssFilterFunctionPropUtil);return o.createElement(s.PropProvider,_extends({},r,{setValue:(e,t,o)=>{let n=structuredClone(e);const a=n?.func.value??"";"func"===o?.bind&&(n=structuredClone(x[a].defaultValue.value)),n.args&&r.setValue(n)}}),o.createElement(i.PopoverContent,{p:1.5},o.createElement(u.PopoverGridContainer,null,o.createElement(a.Grid,{item:!0,xs:6},o.createElement(c.ControlFormLabel,null,(0,l.__)("Filter","elementor"))),o.createElement(a.Grid,{item:!0,xs:6},o.createElement(s.PropKeyProvider,{bind:"func"},o.createElement(f.SelectControl,{options:y.map(e=>({label:x[e].name,value:e}))})))),o.createElement(s.PropKeyProvider,{bind:"args"},o.createElement(Content,{filterType:e?.value.func,anchorEl:t}))))},Content=({filterType:e,anchorEl:t})=>{const r=e?.value||v,n=x[r],{units:a=[]}=n;return isSingleSize(r)?o.createElement(SingleSizeItemContent,{filterType:r}):o.createElement(g.DropShadowItemContent,{units:a,anchorEl:t})},SingleSizeItemContent=({filterType:e})=>{const{valueName:t,defaultValue:r,units:n}=x[e],l=(0,o.useRef)(null),s=r.value.args.value.unit;return o.createElement(u.PopoverGridContainer,{ref:l},o.createElement(a.Grid,{item:!0,xs:6},o.createElement(c.ControlFormLabel,null,t)),o.createElement(a.Grid,{item:!0,xs:6},o.createElement(k.SizeControl,{anchorRef:l,units:n,defaultUnit:s})))}},"./packages/packages/libs/editor-controls/src/controls/font-family-control/enqueue-font.tsx":function(e,t,r){r.r(t),r.d(t,{enqueueFont:function(){return enqueueFont}});const enqueueFont=(e,t="editor")=>{const r=window;return r.elementor?.helpers?.enqueueFont?.(e,t)??null}},"./packages/packages/libs/editor-controls/src/controls/font-family-control/font-family-control.tsx":function(e,t,r){r.r(t),r.d(t,{FontFamilyControl:function(){return p}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/components/font-family-selector.tsx"),i=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx"),u=r("./packages/packages/libs/editor-controls/src/create-control.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const p=(0,u.createControl)(({fontFamilies:e,sectionWidth:t})=>{const{value:r,setValue:u,disabled:p,placeholder:d}=(0,s.useBoundProp)(n.stringPropTypeUtil),m=(0,l.usePopupState)({variant:"popover"}),g=!r&&d;return o.createElement(o.Fragment,null,o.createElement(i.default,null,o.createElement(l.UnstableTag,_extends({variant:"outlined",label:r||d,endIcon:o.createElement(a.ChevronDownIcon,{fontSize:"tiny"})},(0,l.bindTrigger)(m),{fullWidth:!0,disabled:p,sx:g?{"& .MuiTag-label":{color:e=>e.palette.text.tertiary},textTransform:"capitalize"}:void 0}))),o.createElement(l.Popover,_extends({disablePortal:!0,disableScrollLock:!0,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},sx:{my:1.5}},(0,l.bindPopover)(m)),o.createElement(c.FontFamilySelector,{fontFamilies:e,fontFamily:r,onFontFamilyChange:u,onClose:m.close,sectionWidth:t})))})},"./packages/packages/libs/editor-controls/src/controls/gap-control.tsx":function(e,t,r){r.r(t),r.d(t,{GapControl:function(){return m}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("@wordpress/i18n"),c=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),i=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),u=r("./packages/packages/libs/editor-controls/src/components/control-label.tsx"),p=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),d=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");const m=(0,p.createControl)(({label:e})=>{const{value:t,setValue:r,propType:p,disabled:d}=(0,c.useBoundProp)(n.layoutDirectionPropTypeUtil),m=(0,o.useRef)(null),{value:g,setValue:b,disabled:f}=(0,c.useBoundProp)(n.sizePropTypeUtil),k=!t&&!g||!!g,v=e.toLowerCase(),x=k?a.LinkIcon:a.DetachIcon,y=(0,s.__)("Link %s","elementor").replace("%s",v),E=(0,s.__)("Unlink %s","elementor").replace("%s",v),_=f||d;return o.createElement(c.PropProvider,{propType:p,value:t,setValue:r},o.createElement(l.Stack,{direction:"row",gap:2,flexWrap:"nowrap"},o.createElement(u.ControlLabel,null,e),o.createElement(l.Tooltip,{title:k?E:y,placement:"top"},o.createElement(l.ToggleButton,{"aria-label":k?E:y,size:"tiny",value:"check",selected:k,sx:{marginLeft:"auto"},onChange:()=>{if(!k)return void b(t?.column?.value??null);const e=g?n.sizePropTypeUtil.create(g):null;r({row:e,column:e})},disabled:_},o.createElement(x,{fontSize:"tiny"})))),o.createElement(l.Stack,{direction:"row",gap:2,flexWrap:"nowrap",ref:m},o.createElement(l.Grid,{container:!0,gap:.75,alignItems:"center"},o.createElement(l.Grid,{item:!0,xs:12},o.createElement(i.ControlFormLabel,null,(0,s.__)("Column","elementor"))),o.createElement(l.Grid,{item:!0,xs:12},o.createElement(Control,{bind:"column",isLinked:k,anchorRef:m}))),o.createElement(l.Grid,{container:!0,gap:.75,alignItems:"center"},o.createElement(l.Grid,{item:!0,xs:12},o.createElement(i.ControlFormLabel,null,(0,s.__)("Row","elementor"))),o.createElement(l.Grid,{item:!0,xs:12},o.createElement(Control,{bind:"row",isLinked:k,anchorRef:m})))))}),Control=({bind:e,isLinked:t,anchorRef:r})=>t?o.createElement(d.SizeControl,{anchorRef:r}):o.createElement(c.PropKeyProvider,{bind:e},o.createElement(d.SizeControl,{anchorRef:r}))},"./packages/packages/libs/editor-controls/src/controls/image-control.tsx":function(e,t,r){r.r(t),r.d(t,{ImageControl:function(){return m}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),i=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),u=r("./packages/packages/libs/editor-controls/src/hooks/use-unfiltered-files-upload.ts"),p=r("./packages/packages/libs/editor-controls/src/controls/image-media-control.tsx"),d=r("./packages/packages/libs/editor-controls/src/controls/select-control.tsx");const m=(0,i.createControl)(({sizes:e,showMode:t="all"})=>{const r=(0,s.useBoundProp)(n.imagePropTypeUtil);let i;switch(t){case"media":i=o.createElement(ImageSrcControl,null);break;case"sizes":i=o.createElement(ImageSizeControl,{sizes:e});break;default:i=o.createElement(a.Stack,{gap:1.5},o.createElement(c.ControlFormLabel,null,(0,l.__)("Image","elementor")),o.createElement(ImageSrcControl,null),o.createElement(a.Grid,{container:!0,gap:1.5,alignItems:"center",flexWrap:"nowrap"},o.createElement(a.Grid,{item:!0,xs:6},o.createElement(c.ControlFormLabel,null,(0,l.__)("Resolution","elementor"))),o.createElement(a.Grid,{item:!0,xs:6,sx:{overflow:"hidden"}},o.createElement(ImageSizeControl,{sizes:e}))))}return o.createElement(s.PropProvider,r,i)}),ImageSrcControl=()=>{const{data:e}=(0,u.useUnfilteredFilesUpload)(),t=e?["image","svg"]:["image"];return o.createElement(s.PropKeyProvider,{bind:"src"},o.createElement(p.ImageMediaControl,{mediaTypes:t}))},ImageSizeControl=({sizes:e})=>o.createElement(s.PropKeyProvider,{bind:"size"},o.createElement(d.SelectControl,{options:e}))},"./packages/packages/libs/editor-controls/src/controls/image-media-control.tsx":function(e,t,r){r.r(t),r.d(t,{ImageMediaControl:function(){return p}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("@elementor/wp-media"),c=r("@wordpress/i18n"),i=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),u=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx");const p=(0,r("./packages/packages/libs/editor-controls/src/create-control.tsx").createControl)(({mediaTypes:e=["image"]})=>{const{value:t,setValue:r}=(0,i.useBoundProp)(n.imageSrcPropTypeUtil),{id:p,url:d}=t??{},{data:m,isFetching:g}=(0,s.useWpMediaAttachment)(p?.value||null),b=m?.url??d?.value??null,{open:f}=(0,s.useWpMediaFrame)({mediaTypes:e,multiple:!1,selected:p?.value||null,onSelect:e=>{r({id:{$$type:"image-attachment-id",value:e.id},url:null})}});return o.createElement(u.default,null,o.createElement(l.Card,{variant:"outlined"},o.createElement(l.CardMedia,{image:b,sx:{height:150}},g?o.createElement(l.Stack,{justifyContent:"center",alignItems:"center",width:"100%",height:"100%"},o.createElement(l.CircularProgress,null)):o.createElement(o.Fragment,null)),o.createElement(l.CardOverlay,null,o.createElement(l.Stack,{gap:1},o.createElement(l.Button,{size:"tiny",color:"inherit",variant:"outlined",onClick:()=>f({mode:"browse"})},(0,c.__)("Select image","elementor")),o.createElement(l.Button,{size:"tiny",variant:"text",color:"inherit",startIcon:o.createElement(a.UploadIcon,null),onClick:()=>f({mode:"upload"})},(0,c.__)("Upload","elementor"))))))})},"./packages/packages/libs/editor-controls/src/controls/key-value-control.tsx":function(e,t,r){r.r(t),r.d(t,{KeyValueControl:function(){return u}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),i=r("./packages/packages/libs/editor-controls/src/controls/text-control.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const u=(0,c.createControl)((e={})=>{const{value:t,setValue:r,...c}=(0,s.useBoundProp)(n.keyValuePropTypeUtil),[u,p]=(0,o.useState)(""),[d,m]=(0,o.useState)(""),[g,b]=(0,o.useState)({key:t?.key?.value||"",value:t?.value?.value||""}),f=e.keyName||(0,l.__)("Key","elementor"),k=e.valueName||(0,l.__)("Value","elementor"),[v,x,y]=(0,o.useMemo)(()=>[e.regexKey?new RegExp(e.regexKey):void 0,e.regexValue?new RegExp(e.regexValue):void 0,e.validationErrorMessage||(0,l.__)("Invalid Format","elementor")],[e.regexKey,e.regexValue,e.validationErrorMessage]);return o.createElement(s.PropProvider,_extends({},c,{value:t,setValue:(e,o,a)=>{const l=a?.bind;if(!l)return;const s=e[l];if((0,n.isTransformable)(s)&&"dynamic"===s.$$type)return void r({...t,[l]:s});const c=n.stringPropTypeUtil.extract(s);b(e=>({...e,[l]:c})),c&&((e,t)=>{if("key"===t&&v){const t=v.test(e);return p(t?"":y),t}if("value"===t&&x){const t=x.test(e);return m(t?"":y),t}return!0})(c,l)?r({...t,[l]:s}):r({...t,[l]:{value:"",$$type:"string"}})}}),o.createElement(a.Grid,{container:!0,gap:1.5},o.createElement(a.Grid,{item:!0,xs:12,display:"flex",flexDirection:"column"},o.createElement(a.FormLabel,{size:"tiny",sx:{pb:1}},f),o.createElement(s.PropKeyProvider,{bind:"key"},o.createElement(i.TextControl,{inputValue:g.key,error:!!u})),!!u&&o.createElement(a.FormHelperText,{error:!0},u)),o.createElement(a.Grid,{item:!0,xs:12,display:"flex",flexDirection:"column"},o.createElement(a.FormLabel,{size:"tiny",sx:{pb:1}},k),o.createElement(s.PropKeyProvider,{bind:"value"},o.createElement(i.TextControl,{inputValue:g.value,error:!!d,inputDisabled:!!u})),!!d&&o.createElement(a.FormHelperText,{error:!0},d))))})},"./packages/packages/libs/editor-controls/src/controls/link-control.tsx":function(e,t,r){r.r(t),r.d(t,{LinkControl:function(){return E}});var o=r("react"),n=r("@elementor/editor-elements"),a=r("@elementor/editor-props"),l=r("@elementor/editor-ui"),s=r("@elementor/http-client"),c=r("@elementor/icons"),i=r("@elementor/session"),u=r("@elementor/ui"),p=r("@elementor/utils"),d=r("@wordpress/i18n"),m=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),g=r("./packages/packages/libs/editor-controls/src/components/autocomplete.tsx"),b=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),f=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx"),k=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),v=r("./packages/packages/libs/editor-controls/src/controls/switch-control.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const x="tiny",y={label:(0,d.__)("Learn More","elementor"),href:"https://go.elementor.com/element-link-inside-link-infotip"},E=(0,k.createControl)(e=>{const{value:t,path:r,setValue:l,...c}=(0,m.useBoundProp)(a.linkPropTypeUtil),[k,x]=(0,i.useSessionStorage)(r.join("/")),[y,E]=(0,o.useState)(!!t),{allowCustomValues:_,queryOptions:{endpoint:h="",requestParams:P={}},placeholder:C,minInputLength:w=2,context:{elementId:T},label:S=(0,d.__)("Link","elementor")}=e||{},[z,I]=(0,o.useState)((0,n.getLinkInLinkRestriction)(T)),[O,U]=(0,o.useState)(function generateFirstLoadedOption(e){const t=e?.destination?.value,r=e?.label?.value,o=e?.destination?.$$type||"url";return t&&r&&"number"===o?[{id:t.toString(),label:r}]:[]}(t)),F=!y&&z.shouldRestrict,onSaveNewValue=e=>{l(e),x({...k,value:e})},updateOptions=e=>{U([]),!e||!h||e.length<w||B({...P,term:e})},B=(0,o.useMemo)(()=>(0,p.debounce)(e=>async function fetchOptions(e,t){if(!t||!e)return[];try{const{data:r}=await(0,s.httpService)().get(e,{params:t});return r.data.value}catch{return[]}}(h,e).then(e=>{U(function formatOptions(e){const t=(0,g.isCategorizedOptionPool)(e)?"groupLabel":"label";return e.sort((e,r)=>e[t]&&r[t]?e[t].localeCompare(r[t]):0)}(e))}),400),[h]);return o.createElement(m.PropProvider,_extends({},c,{value:t,setValue:l}),o.createElement(u.Stack,{gap:1.5},o.createElement(u.Stack,{direction:"row",sx:{justifyContent:"space-between",alignItems:"center",marginInlineEnd:-.75}},o.createElement(b.ControlFormLabel,null,S),o.createElement(ConditionalInfoTip,{isVisible:!y,linkInLinkRestriction:z},o.createElement(ToggleIconControl,{disabled:F,active:y,onIconClick:()=>{if(I((0,n.getLinkInLinkRestriction)(T)),z.shouldRestrict&&!y)return;const e=!y;E(e),e||null===t||l(null),e&&k?.value&&l(k.value),x({value:k?.value,meta:{isEnabled:e}})},label:(0,d.__)("Toggle link","elementor")}))),o.createElement(u.Collapse,{in:y,timeout:"auto",unmountOnExit:!0},o.createElement(u.Stack,{gap:1.5},o.createElement(m.PropKeyProvider,{bind:"destination"},o.createElement(f.default,null,o.createElement(g.Autocomplete,{options:O,allowCustomValues:_,placeholder:C,value:t?.destination?.value?.settings?.label||t?.destination?.value,onOptionChange:e=>{const r=e?{...t,destination:a.numberPropTypeUtil.create(e),label:a.stringPropTypeUtil.create((0,g.findMatchingOption)(O,e)?.label||null)}:null;onSaveNewValue(r)},onTextChange:e=>{const r=(e=e?.trim()||"")?{...t,destination:a.urlPropTypeUtil.create(e),label:a.stringPropTypeUtil.create("")}:null;onSaveNewValue(r),updateOptions(e)},minInputLength:w}))),o.createElement(m.PropKeyProvider,{bind:"isTargetBlank"},o.createElement(u.Grid,{container:!0,alignItems:"center",flexWrap:"nowrap",justifyContent:"space-between"},o.createElement(u.Grid,{item:!0},o.createElement(b.ControlFormLabel,null,(0,d.__)("Open in a new tab","elementor"))),o.createElement(u.Grid,{item:!0,sx:{marginInlineEnd:-1}},o.createElement(v.SwitchControl,null))))))))}),ToggleIconControl=({disabled:e,active:t,onIconClick:r,label:n})=>o.createElement(u.IconButton,{size:x,onClick:r,"aria-label":n,disabled:e},t?o.createElement(c.MinusIcon,{fontSize:x}):o.createElement(c.PlusIcon,{fontSize:x}));const ConditionalInfoTip=({linkInLinkRestriction:e,isVisible:t,children:r})=>{const{shouldRestrict:a,reason:s,elementId:i}=e;return a&&t?o.createElement(u.Infotip,{placement:"right",content:o.createElement(l.InfoTipCard,{content:_[s],svgIcon:o.createElement(c.AlertTriangleIcon,null),learnMoreButton:y,ctaButton:{label:(0,d.__)("Take me there","elementor"),onClick:()=>{i&&(0,n.selectElement)(i)}}})},o.createElement(u.Box,null,r)):o.createElement(o.Fragment,null,r)},_={descendant:o.createElement(o.Fragment,null,(0,d.__)("To add a link to this container,","elementor"),o.createElement("br",null),(0,d.__)("first remove the link from the elements inside of it.","elementor")),ancestor:o.createElement(o.Fragment,null,(0,d.__)("To add a link to this element,","elementor"),o.createElement("br",null),(0,d.__)("first remove the link from its parent container.","elementor"))}},"./packages/packages/libs/editor-controls/src/controls/linked-dimensions-control.tsx":function(e,t,r){r.r(t),r.d(t,{LinkedDimensionsControl:function(){return m}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("@wordpress/i18n"),c=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),i=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),u=r("./packages/packages/libs/editor-controls/src/components/control-label.tsx"),p=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),d=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");const m=(0,p.createControl)(({label:e,isSiteRtl:t=!1,extendedOptions:r})=>{const{value:u,setValue:p,disabled:d}=(0,c.useBoundProp)(n.sizePropTypeUtil),m=[(0,o.useRef)(null),(0,o.useRef)(null)],{value:g,setValue:b,propType:f,disabled:k}=(0,c.useBoundProp)(n.dimensionsPropTypeUtil),v=!g&&!u||!!u,x=e.toLowerCase(),y=v?a.LinkIcon:a.DetachIcon,E=(0,s.__)("Link %s","elementor").replace("%s",x),_=(0,s.__)("Unlink %s","elementor").replace("%s",x),h=d||k;return o.createElement(c.PropProvider,{propType:f,value:g,setValue:b,isDisabled:()=>h},o.createElement(l.Stack,{direction:"row",gap:2,flexWrap:"nowrap"},o.createElement(i.ControlFormLabel,null,e),o.createElement(l.Tooltip,{title:v?_:E,placement:"top"},o.createElement(l.ToggleButton,{"aria-label":v?_:E,size:"tiny",value:"check",selected:v,sx:{marginLeft:"auto"},onChange:()=>{if(!v)return void p(g["block-start"]?.value??null);const e=u?n.sizePropTypeUtil.create(u):null;b({"block-start":e,"block-end":e,"inline-start":e,"inline-end":e})},disabled:h},o.createElement(y,{fontSize:"tiny"})))),function getCssMarginProps(e){return[[{bind:"block-start",label:(0,s.__)("Top","elementor"),icon:o.createElement(a.SideTopIcon,{fontSize:"tiny"})},{bind:"inline-end",label:e?(0,s.__)("Left","elementor"):(0,s.__)("Right","elementor"),icon:e?o.createElement(a.SideLeftIcon,{fontSize:"tiny"}):o.createElement(a.SideRightIcon,{fontSize:"tiny"})}],[{bind:"block-end",label:(0,s.__)("Bottom","elementor"),icon:o.createElement(a.SideBottomIcon,{fontSize:"tiny"})},{bind:"inline-start",label:e?(0,s.__)("Right","elementor"):(0,s.__)("Left","elementor"),icon:e?o.createElement(a.SideRightIcon,{fontSize:"tiny"}):o.createElement(a.SideLeftIcon,{fontSize:"tiny"})}]]}(t).map((e,t)=>o.createElement(l.Stack,{direction:"row",gap:2,flexWrap:"nowrap",key:t,ref:m[t]},e.map(({icon:e,...n})=>o.createElement(l.Grid,{container:!0,gap:.75,alignItems:"center",key:n.bind},o.createElement(l.Grid,{item:!0,xs:12},o.createElement(Label,n)),o.createElement(l.Grid,{item:!0,xs:12},o.createElement(Control,{bind:n.bind,startIcon:e,isLinked:v,extendedOptions:r,anchorRef:m[t]})))))))}),Control=({bind:e,startIcon:t,isLinked:r,extendedOptions:n,anchorRef:a})=>r?o.createElement(d.SizeControl,{startIcon:t,extendedOptions:n,anchorRef:a}):o.createElement(c.PropKeyProvider,{bind:e},o.createElement(d.SizeControl,{startIcon:t,extendedOptions:n,anchorRef:a})),Label=({label:e,bind:t})=>o.createElement(c.PropKeyProvider,{bind:t},o.createElement(u.ControlLabel,null,e))},"./packages/packages/libs/editor-controls/src/controls/number-control.tsx":function(e,t,r){r.r(t),r.d(t,{NumberControl:function(){return u}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),s=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx"),c=r("./packages/packages/libs/editor-controls/src/create-control.tsx");const isEmptyOrNaN=e=>null==e||""===e||Number.isNaN(Number(e)),i=["e","E","+","-"],u=(0,c.createControl)(({placeholder:e,max:t=Number.MAX_VALUE,min:r=-Number.MAX_VALUE,step:c=1,shouldForceInt:u=!1,startIcon:p})=>{const{value:d,setValue:m,placeholder:g,disabled:b}=(0,l.useBoundProp)(n.numberPropTypeUtil);return o.createElement(s.default,null,o.createElement(a.TextField,{size:"tiny",type:"number",fullWidth:!0,disabled:b,value:isEmptyOrNaN(d)?"":d,onChange:e=>{const o=e.target.value;if(isEmptyOrNaN(o))return void m(null);const n=u?+parseInt(o):Number(o);m(Math.min(Math.max(n,r),t))},placeholder:e??(g?String(g):""),inputProps:{step:c},InputProps:{startAdornment:p?o.createElement(a.InputAdornment,{position:"start",disabled:b},p):void 0},onKeyDown:e=>{i.includes(e.key)&&e.preventDefault()}}))})},"./packages/packages/libs/editor-controls/src/controls/position-control.tsx":function(e,t,r){r.r(t),r.d(t,{PositionControl:function(){return PositionControl}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/editor-ui"),l=r("@elementor/icons"),s=r("@elementor/ui"),c=r("@wordpress/i18n"),i=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),u=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),p=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");const d=[{label:(0,c.__)("Center center","elementor"),value:"center center"},{label:(0,c.__)("Center left","elementor"),value:"center left"},{label:(0,c.__)("Center right","elementor"),value:"center right"},{label:(0,c.__)("Top center","elementor"),value:"top center"},{label:(0,c.__)("Top left","elementor"),value:"top left"},{label:(0,c.__)("Top right","elementor"),value:"top right"},{label:(0,c.__)("Bottom center","elementor"),value:"bottom center"},{label:(0,c.__)("Bottom left","elementor"),value:"bottom left"},{label:(0,c.__)("Bottom right","elementor"),value:"bottom right"},{label:(0,c.__)("Custom","elementor"),value:"custom"}],PositionControl=()=>{const e=(0,i.useBoundProp)(n.positionPropTypeUtil),t=(0,i.useBoundProp)(n.stringPropTypeUtil),r=!!e.value;return o.createElement(s.Grid,{container:!0,spacing:1.5},o.createElement(s.Grid,{item:!0,xs:12},o.createElement(s.Grid,{container:!0,gap:2,alignItems:"center",flexWrap:"nowrap"},o.createElement(s.Grid,{item:!0,xs:6},o.createElement(u.ControlFormLabel,null,(0,c.__)("Object position","elementor"))),o.createElement(s.Grid,{item:!0,xs:6,sx:{overflow:"hidden"}},o.createElement(s.Select,{size:"tiny",disabled:t.disabled,value:(e.value?"custom":t.value)??"",onChange:r=>{const o=r.target.value||null;"custom"===o?e.setValue({x:null,y:null}):t.setValue(o)},fullWidth:!0},d.map(({label:e,value:t})=>o.createElement(a.MenuListItem,{key:t,value:t??""},e)))))),r&&o.createElement(i.PropProvider,e,o.createElement(s.Grid,{item:!0,xs:12},o.createElement(s.Grid,{container:!0,spacing:1.5},o.createElement(s.Grid,{item:!0,xs:6},o.createElement(i.PropKeyProvider,{bind:"x"},o.createElement(p.SizeControl,{startIcon:o.createElement(l.LetterXIcon,{fontSize:"tiny"})}))),o.createElement(s.Grid,{item:!0,xs:6},o.createElement(i.PropKeyProvider,{bind:"y"},o.createElement(p.SizeControl,{startIcon:o.createElement(l.LetterYIcon,{fontSize:"tiny"})})))))))}},"./packages/packages/libs/editor-controls/src/controls/repeatable-control.tsx":function(e,t,r){r.r(t),r.d(t,{RepeatableControl:function(){return m}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),s=r("./packages/packages/libs/editor-controls/src/components/popover-content.tsx"),c=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),i=r("./packages/packages/libs/editor-controls/src/components/repeater.tsx"),u=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),p=r("./packages/packages/libs/editor-controls/src/hooks/use-repeatable-control-context.ts");const d=/\$\{([^}]+)\}/g,m=(0,u.createControl)(({repeaterLabel:e,childControlConfig:t,showDuplicate:r,showToggle:a,initialValues:s,patternLabel:c,placeholder:u})=>{const{propTypeUtil:d}=t;if(!d)return null;const m=(0,o.useMemo)(()=>(0,n.createArrayPropUtils)(d.key,d.schema),[d.key,d.schema]),g=(0,o.useMemo)(()=>({...t,placeholder:u||"",patternLabel:c||""}),[t,u,c]),{propType:b,value:f,setValue:k}=(0,l.useBoundProp)(m);return o.createElement(l.PropProvider,{propType:b,value:f,setValue:k},o.createElement(p.RepeatableControlContext.Provider,{value:g},o.createElement(i.Repeater,{openOnAdd:!0,values:f??[],setValues:k,label:e,isSortable:!1,itemSettings:{Icon:ItemIcon,Label:ItemLabel,Content:ItemContent,initialValues:d.create(s||null)},showDuplicate:r,showToggle:a})))}),ItemContent=({bind:e})=>o.createElement(l.PropKeyProvider,{bind:e},o.createElement(Content,null)),ItemIcon=()=>o.createElement(o.Fragment,null),Content=()=>{const{component:e,props:t={}}=(0,p.useRepeatableControlContext)();return o.createElement(s.PopoverContent,{p:1.5},o.createElement(c.PopoverGridContainer,null,o.createElement(e,t)))},getNestedValue=(e,t)=>t.split(".").reduce((e,t)=>e&&"object"==typeof e?e[t]:{},e),isEmptyValue=e=>"string"==typeof e?""===e.trim():!!Number.isNaN(e)||(Array.isArray(e)?0===e.length:"object"==typeof e&&null!==e&&0===Object.keys(e).length),ItemLabel=({value:e})=>{const{placeholder:t,patternLabel:r}=(0,p.useRepeatableControlContext)(),n=((e,t)=>{const r=getAllProperties(e).map(e=>getNestedValue(t,e));return!(0===r.length||!r.some(e=>null==e)&&!r.every(isEmptyValue))})(r,e)?t:(l=r,(s=e)?l.replace(d,(e,t)=>{const r=getNestedValue(s,t);return"object"!=typeof r||null===r||Array.isArray(r)?Array.isArray(r)?r.join(", "):String(r??""):r.name?r.name:JSON.stringify(r)}):l);var l,s;return o.createElement(a.Box,{component:"span",color:"text.tertiary"},n)},getAllProperties=e=>e.match(d)?.map(e=>e.slice(2,-1))||[]},"./packages/packages/libs/editor-controls/src/controls/select-control.tsx":function(e,t,r){r.r(t),r.d(t,{SelectControl:function(){return i}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/editor-ui"),l=r("@elementor/ui"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const i=(0,r("./packages/packages/libs/editor-controls/src/create-control.tsx").createControl)(({options:e,onChange:t})=>{const{value:r,setValue:i,disabled:u,placeholder:p}=(0,s.useBoundProp)(n.stringPropTypeUtil);return o.createElement(c.default,null,o.createElement(l.Select,{sx:{overflow:"hidden"},displayEmpty:!0,size:"tiny",renderValue:t=>{const findOptionByValue=t=>e.find(e=>e.value===t);if(!t||""===t){if(p){const e=findOptionByValue(p),t=e?.label||p;return o.createElement(l.Typography,{component:"span",variant:"caption",color:"text.tertiary"},t)}return""}const r=findOptionByValue(t);return r?.label||t},value:r??"",onChange:e=>{const o=e.target.value||null;t?.(o,r),i(o)},disabled:u,fullWidth:!0},e.map(({label:e,...t})=>o.createElement(a.MenuListItem,_extends({key:t.value},t,{value:t.value??""}),e))))})},"./packages/packages/libs/editor-controls/src/controls/size-control.tsx":function(e,t,r){r.r(t),r.d(t,{SizeControl:function(){return f}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/editor-responsive"),l=r("@elementor/ui"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/components/size-control/size-input.tsx"),i=r("./packages/packages/libs/editor-controls/src/components/text-field-popover.tsx"),u=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),p=r("./packages/packages/libs/editor-controls/src/hooks/use-size-extended-options.ts"),d=r("./packages/packages/libs/editor-controls/src/hooks/use-sync-external-state.tsx"),m=r("./packages/packages/libs/editor-controls/src/utils/size-control.ts");const g={length:"px",angle:"deg",time:"ms"},b={length:[...m.lengthUnits],angle:[...m.angleUnits],time:[...m.timeUnits]},f=(0,u.createControl)(({variant:e="length",defaultUnit:t,units:r,placeholder:u,startIcon:f,anchorRef:k,extendedOptions:v,disableCustom:x})=>{const y=t??g[e],E=r??[...b[e]],{value:_,setValue:h,disabled:P,restoreValue:C}=(0,s.useBoundProp)(n.sizePropTypeUtil),[w,T]=(0,o.useState)(createStateFromSizeProp(_,y)),S=(0,a.useActiveBreakpoint)(),z=(0,p.useSizeExtendedOptions)(v||[],x??!1),I=(0,l.usePopupState)({variant:"popover"}),[O,U]=(0,d.useSyncExternalState)({external:w,setExternal:e=>h(extractValueFromState(e)),persistWhen:e=>!!e?.unit&&((0,m.isUnitExtendedOption)(e.unit)?"auto"===e.unit||!!e.custom:!!e?.numeric||0===e?.numeric),fallback:e=>({unit:e?.unit??y,numeric:e?.numeric??m.DEFAULT_SIZE,custom:e?.custom??""})}),{size:F=m.DEFAULT_SIZE,unit:B=y}=extractValueFromState(O)||{},handleSizeChange=e=>{const{value:t}=e.target;U("auto"!==B?e=>({...e,["custom"===B?"custom":"numeric"]:formatSize(t,B),unit:B}):e=>({...e,unit:B}))};return(0,o.useEffect)(()=>{const e=createStateFromSizeProp(_,"custom"===O.unit?O.unit:y),t=(0,m.isUnitExtendedOption)(O.unit)?"custom":"numeric",r={...O,unit:e.unit??O.unit,[t]:e[t]};"auto"!==r.unit&&areStatesEqual(O,r)||(O.unit!==e.unit?U(e):T(r))},[_]),(0,o.useEffect)(()=>{const e=createStateFromSizeProp(_,y);S&&!areStatesEqual(e,O)&&U(e)},[S]),o.createElement(o.Fragment,null,o.createElement(c.SizeInput,{disabled:P,size:F,unit:B,units:[...E,...z||[]],placeholder:u,startIcon:f,handleSizeChange:handleSizeChange,handleUnitChange:e=>{"custom"===e&&I.open(k?.current),U(t=>({...t,unit:e}))},onBlur:C,onFocus:e=>{(0,m.isUnitExtendedOption)(O.unit)&&e.target?.blur()},onClick:e=>{e.target.closest("input")&&"custom"===O.unit&&I.open(k?.current)},popupState:I}),k?.current&&o.createElement(i.TextFieldPopover,{popupState:I,anchorRef:k,restoreValue:C,value:F,onChange:handleSizeChange}))});function formatSize(e,t){return(0,m.isUnitExtendedOption)(t)?"auto"===t?"":String(e??""):e||0===e?Number(e):NaN}function createStateFromSizeProp(e,t){const r=e?.unit??t,o=e?.size??"";return{numeric:(0,m.isUnitExtendedOption)(r)||isNaN(Number(o))||!o&&0!==o?m.DEFAULT_SIZE:Number(o),custom:"custom"===r?String(o):"",unit:r}}function extractValueFromState(e){if(!e)return null;if(!e?.unit)return{size:m.DEFAULT_SIZE,unit:m.DEFAULT_UNIT};const{unit:t}=e;return"auto"===t?{size:"",unit:t}:{size:e["custom"===t?"custom":"numeric"],unit:t}}function areStatesEqual(e,t){return e.unit===t.unit&&e.custom===t.custom&&((0,m.isUnitExtendedOption)(e.unit)?e.custom===t.custom:e.numeric===t.numeric||isNaN(e.numeric)&&isNaN(t.numeric))}},"./packages/packages/libs/editor-controls/src/controls/stroke-control.tsx":function(e,t,r){r.r(t),r.d(t,{StrokeControl:function(){return g}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("@wordpress/i18n"),s=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),c=r("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),i=r("./packages/packages/libs/editor-controls/src/components/section-content.tsx"),u=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),p=r("./packages/packages/libs/editor-controls/src/controls/color-control.tsx"),d=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");const m=["px","em","rem"],g=(0,u.createControl)(()=>{const e=(0,s.useBoundProp)(n.strokePropTypeUtil),t=(0,o.useRef)(null);return o.createElement(s.PropProvider,e,o.createElement(i.SectionContent,null,o.createElement(b,{bind:"width",label:(0,l.__)("Stroke width","elementor"),ref:t},o.createElement(d.SizeControl,{units:m,anchorRef:t})),o.createElement(b,{bind:"color",label:(0,l.__)("Stroke color","elementor")},o.createElement(p.ColorControl,null))))}),b=(0,o.forwardRef)(({bind:e,label:t,children:r},n)=>o.createElement(s.PropKeyProvider,{bind:e},o.createElement(a.Grid,{container:!0,gap:2,alignItems:"center",flexWrap:"nowrap",ref:n},o.createElement(a.Grid,{item:!0,xs:6},o.createElement(c.ControlFormLabel,null,t)),o.createElement(a.Grid,{item:!0,xs:6},r))))},"./packages/packages/libs/editor-controls/src/controls/svg-media-control.tsx":function(e,t,r){r.r(t),r.d(t,{SvgMediaControl:function(){return E}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("@elementor/wp-media"),c=r("@wordpress/i18n"),i=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),u=r("./packages/packages/libs/editor-controls/src/components/enable-unfiltered-modal.tsx"),p=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx"),d=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),m=r("./packages/packages/libs/editor-controls/src/hooks/use-unfiltered-files-upload.ts");const g="transparent",b="#c1c1c1",f=`linear-gradient(45deg, ${b} 25%, ${g} 0, ${g} 75%, ${b} 0, ${b})`,k=(0,l.styled)(l.Card)`
	background-color: white;
	background-image: ${f}, ${f};
	background-size: ${8}px ${8}px;
	background-position:
		0 0,
		${4}px ${4}px;
	border: none;
`,v=(0,l.styled)(l.Stack)`
	position: relative;
	height: 140px;
	object-fit: contain;
	padding: 5px;
	justify-content: center;
	align-items: center;
	background-color: rgba( 255, 255, 255, 0.37 );
`,x={mode:"browse"},y={mode:"upload"},E=(0,d.createControl)(()=>{const{value:e,setValue:t}=(0,i.useBoundProp)(n.imageSrcPropTypeUtil),{id:r,url:d}=e??{},{data:g,isFetching:b}=(0,s.useWpMediaAttachment)(r?.value||null),f=g?.url??d?.value??null,{data:E}=(0,m.useUnfilteredFilesUpload)(),[_,h]=(0,o.useState)(!1),{open:P}=(0,s.useWpMediaFrame)({mediaTypes:["svg"],multiple:!1,selected:r?.value||null,onSelect:e=>{t({id:{$$type:"image-attachment-id",value:e.id},url:null})}}),handleClick=e=>{E||e!==y?P(e):h(!0)};return o.createElement(l.Stack,{gap:1},o.createElement(u.EnableUnfilteredModal,{open:_,onClose:e=>{h(!1),e&&P(y)}}),o.createElement(p.default,null,o.createElement(k,{variant:"outlined"},o.createElement(v,null,b?o.createElement(l.CircularProgress,{role:"progressbar"}):o.createElement(l.CardMedia,{component:"img",image:f,alt:(0,c.__)("Preview SVG","elementor"),sx:{maxHeight:"140px",width:"50px"}})),o.createElement(l.CardOverlay,{sx:{"&:hover":{backgroundColor:"rgba( 0, 0, 0, 0.75 )"}}},o.createElement(l.Stack,{gap:1},o.createElement(l.Button,{size:"tiny",color:"inherit",variant:"outlined",onClick:()=>handleClick(x)},(0,c.__)("Select SVG","elementor")),o.createElement(l.Button,{size:"tiny",variant:"text",color:"inherit",startIcon:o.createElement(a.UploadIcon,null),onClick:()=>handleClick(y)},(0,c.__)("Upload","elementor")))))))})},"./packages/packages/libs/editor-controls/src/controls/switch-control.tsx":function(e,t,r){r.r(t),r.d(t,{SwitchControl:function(){return s}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/use-bound-prop.ts");const s=(0,r("./packages/packages/libs/editor-controls/src/create-control.tsx").createControl)(()=>{const{value:e,setValue:t,disabled:r}=(0,l.useBoundProp)(n.booleanPropTypeUtil);return o.createElement("div",{style:{display:"flex",justifyContent:"flex-end"}},o.createElement(a.Switch,{checked:!!e,onChange:e=>{t(e.target.checked)},size:"small",disabled:r,inputProps:{...r?{style:{opacity:0}}:{}}}))})},"./packages/packages/libs/editor-controls/src/controls/text-area-control.tsx":function(e,t,r){r.r(t),r.d(t,{TextAreaControl:function(){return c}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),s=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx");const c=(0,r("./packages/packages/libs/editor-controls/src/create-control.tsx").createControl)(({placeholder:e})=>{const{value:t,setValue:r,disabled:c}=(0,l.useBoundProp)(n.stringPropTypeUtil);return o.createElement(s.default,null,o.createElement(a.TextField,{size:"tiny",multiline:!0,fullWidth:!0,minRows:5,disabled:c,value:t??"",onChange:e=>{r(e.target.value)},placeholder:e}))})},"./packages/packages/libs/editor-controls/src/controls/text-control.tsx":function(e,t,r){r.r(t),r.d(t,{TextControl:function(){return c}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),s=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx");const c=(0,r("./packages/packages/libs/editor-controls/src/create-control.tsx").createControl)(({placeholder:e,error:t,inputValue:r,inputDisabled:c,sx:i})=>{const{value:u,setValue:p,disabled:d}=(0,l.useBoundProp)(n.stringPropTypeUtil);return o.createElement(s.default,null,o.createElement(a.TextField,{size:"tiny",fullWidth:!0,disabled:c??d,value:r??u??"",onChange:e=>p(e.target.value),placeholder:e,error:t,sx:i}))})},"./packages/packages/libs/editor-controls/src/controls/toggle-control.tsx":function(e,t,r){r.r(t),r.d(t,{ToggleControl:function(){return s}});var o=r("react"),n=r("@elementor/editor-props"),a=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),l=r("./packages/packages/libs/editor-controls/src/components/control-toggle-button-group.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const s=(0,r("./packages/packages/libs/editor-controls/src/create-control.tsx").createControl)(({options:e,fullWidth:t=!1,size:r="tiny",exclusive:s=!0,maxItems:c})=>{const{value:i,setValue:u,placeholder:p,disabled:d}=(0,a.useBoundProp)(n.stringPropTypeUtil),m=e.filter(e=>e.exclusive).map(e=>e.value),g={items:e,maxItems:c,fullWidth:t,size:r,placeholder:p};return s?o.createElement(l.ControlToggleButtonGroup,_extends({},g,{value:i??null,onChange:u,disabled:d,exclusive:!0})):o.createElement(l.ControlToggleButtonGroup,_extends({},g,{value:i?.split(" ")??[],onChange:e=>{const t=e[e.length-1],r=m.includes(t)?[t]:e?.filter(e=>!m.includes(e));u(r?.join(" ")||null)},disabled:d,exclusive:!1}))})},"./packages/packages/libs/editor-controls/src/controls/transform-control/functions/axis-row.tsx":function(e,t,r){r.r(t),r.d(t,{AxisRow:function(){return AxisRow}});var o=r("react"),n=r("@elementor/ui"),a=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),l=r("./packages/packages/libs/editor-controls/src/components/control-label.tsx"),s=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),c=r("./packages/packages/libs/editor-controls/src/controls/size-control.tsx");const AxisRow=({label:e,bindValue:t,startIcon:r,anchorRef:i,units:u})=>o.createElement(n.Grid,{item:!0,xs:12},o.createElement(s.PopoverGridContainer,{ref:i},o.createElement(n.Grid,{item:!0,xs:6},o.createElement(l.ControlLabel,null,e)),o.createElement(n.Grid,{item:!0,xs:6},o.createElement(a.PropKeyProvider,{bind:t},o.createElement(c.SizeControl,{anchorRef:i,startIcon:r,units:u,variant:"angle"})))))},"./packages/packages/libs/editor-controls/src/controls/transform-control/functions/move.tsx":function(e,t,r){r.r(t),r.d(t,{Move:function(){return Move}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("@wordpress/i18n"),c=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),i=r("./packages/packages/libs/editor-controls/src/controls/transform-control/types.ts"),u=r("./packages/packages/libs/editor-controls/src/controls/transform-control/functions/axis-row.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const p=[{label:(0,s.__)("Move X","elementor"),bindValue:"x",startIcon:o.createElement(a.ArrowRightIcon,{fontSize:"tiny"})},{label:(0,s.__)("Move Y","elementor"),bindValue:"y",startIcon:o.createElement(a.ArrowDownSmallIcon,{fontSize:"tiny"})},{label:(0,s.__)("Move Z","elementor"),bindValue:"z",startIcon:o.createElement(a.ArrowDownLeftIcon,{fontSize:"tiny"})}],Move=()=>{const e=(0,c.useBoundProp)(n.moveTransformPropTypeUtil),t=(0,o.useRef)(null);return o.createElement(l.Grid,{container:!0,spacing:1.5},o.createElement(c.PropProvider,e,o.createElement(c.PropKeyProvider,{bind:i.TransformFunctionKeys.move},p.map(e=>o.createElement(u.AxisRow,_extends({key:e.bindValue},e,{anchorRef:t}))))))}},"./packages/packages/libs/editor-controls/src/controls/transform-control/functions/rotate.tsx":function(e,t,r){r.r(t),r.d(t,{Rotate:function(){return Rotate}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("@wordpress/i18n"),c=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),i=r("./packages/packages/libs/editor-controls/src/controls/transform-control/types.ts"),u=r("./packages/packages/libs/editor-controls/src/controls/transform-control/functions/axis-row.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const p=[{label:(0,s.__)("Rotate X","elementor"),bindValue:"x",startIcon:o.createElement(a.Arrow360Icon,{fontSize:"tiny"})},{label:(0,s.__)("Rotate Y","elementor"),bindValue:"y",startIcon:o.createElement(a.Arrow360Icon,{fontSize:"tiny",style:{transform:"scaleX(-1) rotate(-90deg)"}})},{label:(0,s.__)("Rotate Z","elementor"),bindValue:"z",startIcon:o.createElement(a.RotateClockwiseIcon,{fontSize:"tiny"})}],d=["deg","rad","grad","turn"],Rotate=()=>{const e=(0,c.useBoundProp)(n.rotateTransformPropTypeUtil),t=(0,o.useRef)(null);return o.createElement(l.Grid,{container:!0,spacing:1.5},o.createElement(c.PropProvider,e,o.createElement(c.PropKeyProvider,{bind:i.TransformFunctionKeys.rotate},p.map(e=>o.createElement(u.AxisRow,_extends({key:e.bindValue},e,{anchorRef:t,units:d}))))))}},"./packages/packages/libs/editor-controls/src/controls/transform-control/functions/scale-axis-row.tsx":function(e,t,r){r.r(t),r.d(t,{ScaleAxisRow:function(){return ScaleAxisRow}});var o=r("react"),n=r("@elementor/ui"),a=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),l=r("./packages/packages/libs/editor-controls/src/components/control-label.tsx"),s=r("./packages/packages/libs/editor-controls/src/components/popover-grid-container.tsx"),c=r("./packages/packages/libs/editor-controls/src/controls/number-control.tsx");const ScaleAxisRow=({label:e,bindValue:t,startIcon:r,anchorRef:i})=>o.createElement(n.Grid,{item:!0,xs:12},o.createElement(s.PopoverGridContainer,{ref:i},o.createElement(n.Grid,{item:!0,xs:6},o.createElement(l.ControlLabel,null,e)),o.createElement(n.Grid,{item:!0,xs:6},o.createElement(a.PropKeyProvider,{bind:t},o.createElement(c.NumberControl,{step:.1,placeholder:"1",startIcon:r})))))},"./packages/packages/libs/editor-controls/src/controls/transform-control/functions/scale.tsx":function(e,t,r){r.r(t),r.d(t,{Scale:function(){return Scale}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("@wordpress/i18n"),c=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),i=r("./packages/packages/libs/editor-controls/src/controls/transform-control/types.ts"),u=r("./packages/packages/libs/editor-controls/src/controls/transform-control/functions/scale-axis-row.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const p=[{label:(0,s.__)("Scale X","elementor"),bindValue:"x",startIcon:o.createElement(a.ArrowRightIcon,{fontSize:"tiny"})},{label:(0,s.__)("Scale Y","elementor"),bindValue:"y",startIcon:o.createElement(a.ArrowDownSmallIcon,{fontSize:"tiny"})},{label:(0,s.__)("Scale Z","elementor"),bindValue:"z",startIcon:o.createElement(a.ArrowDownLeftIcon,{fontSize:"tiny"})}],Scale=()=>{const e=(0,c.useBoundProp)(n.scaleTransformPropTypeUtil),t=(0,o.useRef)(null);return o.createElement(l.Grid,{container:!0,spacing:1.5},o.createElement(c.PropProvider,e,o.createElement(c.PropKeyProvider,{bind:i.TransformFunctionKeys.scale},p.map(e=>o.createElement(u.ScaleAxisRow,_extends({key:e.bindValue},e,{anchorRef:t}))))))}},"./packages/packages/libs/editor-controls/src/controls/transform-control/functions/skew.tsx":function(e,t,r){r.r(t),r.d(t,{Skew:function(){return Skew}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/icons"),l=r("@elementor/ui"),s=r("@wordpress/i18n"),c=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),i=r("./packages/packages/libs/editor-controls/src/controls/transform-control/types.ts"),u=r("./packages/packages/libs/editor-controls/src/controls/transform-control/functions/axis-row.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const p=[{label:(0,s.__)("Skew X","elementor"),bindValue:"x",startIcon:o.createElement(a.ArrowRightIcon,{fontSize:"tiny"})},{label:(0,s.__)("Skew Y","elementor"),bindValue:"y",startIcon:o.createElement(a.ArrowLeftIcon,{fontSize:"tiny",style:{transform:"scaleX(-1) rotate(-90deg)"}})}],d=["deg","rad","grad","turn"],Skew=()=>{const e=(0,c.useBoundProp)(n.skewTransformPropTypeUtil),t=(0,o.useRef)(null);return o.createElement(l.Grid,{container:!0,spacing:1.5},o.createElement(c.PropProvider,e,o.createElement(c.PropKeyProvider,{bind:i.TransformFunctionKeys.skew},p.map(e=>o.createElement(u.AxisRow,_extends({key:e.bindValue},e,{anchorRef:t,units:d}))))))}},"./packages/packages/libs/editor-controls/src/controls/transform-control/transform-content.tsx":function(e,t,r){r.r(t),r.d(t,{TransformContent:function(){return TransformContent}});var o=r("react"),n=r("@elementor/ui"),a=r("@wordpress/i18n"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),s=r("./packages/packages/libs/editor-controls/src/components/popover-content.tsx"),c=r("./packages/packages/libs/editor-controls/src/controls/transform-control/functions/move.tsx"),i=r("./packages/packages/libs/editor-controls/src/controls/transform-control/functions/rotate.tsx"),u=r("./packages/packages/libs/editor-controls/src/controls/transform-control/functions/scale.tsx"),p=r("./packages/packages/libs/editor-controls/src/controls/transform-control/functions/skew.tsx"),d=r("./packages/packages/libs/editor-controls/src/controls/transform-control/types.ts"),m=r("./packages/packages/libs/editor-controls/src/controls/transform-control/use-transform-tabs-history.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var o in r)({}).hasOwnProperty.call(r,o)&&(e[o]=r[o])}return e},_extends.apply(null,arguments)}const TransformContent=({bind:e})=>o.createElement(l.PropKeyProvider,{bind:e},o.createElement(Content,null)),Content=()=>{const{getTabsProps:e,getTabProps:t,getTabPanelProps:r}=(0,m.useTransformTabsHistory)({move:d.initialTransformValue.value,scale:d.initialScaleValue.value,rotate:d.initialRotateValue.value,skew:d.initialSkewValue.value});return o.createElement(s.PopoverContent,null,o.createElement(n.Box,{sx:{width:"100%"}},o.createElement(n.Box,{sx:{borderBottom:1,borderColor:"divider"}},o.createElement(n.Tabs,_extends({size:"small",variant:"fullWidth"},e(),{"aria-label":(0,a.__)("Transform","elementor")}),o.createElement(n.Tab,_extends({label:(0,a.__)("Move","elementor")},t(d.TransformFunctionKeys.move))),o.createElement(n.Tab,_extends({label:(0,a.__)("Scale","elementor")},t(d.TransformFunctionKeys.scale))),o.createElement(n.Tab,_extends({label:(0,a.__)("Rotate","elementor")},t(d.TransformFunctionKeys.rotate))),o.createElement(n.Tab,_extends({label:(0,a.__)("Skew","elementor")},t(d.TransformFunctionKeys.skew))))),o.createElement(n.TabPanel,_extends({sx:{p:1.5}},r(d.TransformFunctionKeys.move)),o.createElement(c.Move,null)),o.createElement(n.TabPanel,_extends({sx:{p:1.5}},r(d.TransformFunctionKeys.scale)),o.createElement(u.Scale,null)),o.createElement(n.TabPanel,_extends({sx:{p:1.5}},r(d.TransformFunctionKeys.rotate)),o.createElement(i.Rotate,null)),o.createElement(n.TabPanel,_extends({sx:{p:1.5}},r(d.TransformFunctionKeys.skew)),o.createElement(p.Skew,null))))}},"./packages/packages/libs/editor-controls/src/controls/transform-control/transform-icon.tsx":function(e,t,r){r.r(t),r.d(t,{TransformIcon:function(){return TransformIcon}});var o=r("react"),n=r("@elementor/icons"),a=r("./packages/packages/libs/editor-controls/src/controls/transform-control/types.ts");const TransformIcon=({value:e})=>{switch(e.$$type){case a.TransformFunctionKeys.move:return o.createElement(n.ArrowsMaximizeIcon,{fontSize:"tiny"});case a.TransformFunctionKeys.scale:return o.createElement(n.ExpandIcon,{fontSize:"tiny"});case a.TransformFunctionKeys.rotate:return o.createElement(n.RotateClockwise2Icon,{fontSize:"tiny"});case a.TransformFunctionKeys.skew:return o.createElement(n.SkewXIcon,{fontSize:"tiny"});default:return null}}},"./packages/packages/libs/editor-controls/src/controls/transform-control/transform-label.tsx":function(e,t,r){r.r(t),r.d(t,{TransformLabel:function(){return TransformLabel}});var o=r("react"),n=r("@elementor/ui"),a=r("@wordpress/i18n"),l=r("./packages/packages/libs/editor-controls/src/controls/transform-control/types.ts");const transformMoveValue=e=>Object.values(e).map(e=>`${e?.value?.size??l.defaultValues.move.size}${e?.value?.unit??l.defaultValues.move.unit}`).join(", "),transformScaleValue=e=>Object.values(e).map(e=>e?.value||l.defaultValues.scale).join(", "),transformRotateValue=e=>Object.values(e).map(e=>`${e?.value?.size??l.defaultValues.rotate.size}${e?.value?.unit??l.defaultValues.rotate.unit}`).join(", "),transformSkewValue=e=>Object.values(e).map(e=>`${e?.value?.size??l.defaultValues.skew.size}${e?.value?.unit??l.defaultValues.skew.unit}`).join(", "),TransformLabel=e=>{const{$$type:t,value:r}=e.value;switch(t){case l.TransformFunctionKeys.move:return o.createElement(Label,{label:(0,a.__)("Move","elementor"),value:transformMoveValue(r)});case l.TransformFunctionKeys.scale:return o.createElement(Label,{label:(0,a.__)("Scale","elementor"),value:transformScaleValue(r)});case l.TransformFunctionKeys.rotate:return o.createElement(Label,{label:(0,a.__)("Rotate","elementor"),value:transformRotateValue(r)});case l.TransformFunctionKeys.skew:return o.createElement(Label,{label:(0,a.__)("Skew","elementor"),value:transformSkewValue(r)});default:return""}},Label=({label:e,value:t})=>o.createElement(n.Box,{component:"span"},e,": ",t)},"./packages/packages/libs/editor-controls/src/controls/transform-control/transform-repeater-control.tsx":function(e,t,r){r.r(t),r.d(t,{TransformRepeaterControl:function(){return m}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@wordpress/i18n"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),s=r("./packages/packages/libs/editor-controls/src/components/repeater.tsx"),c=r("./packages/packages/libs/editor-controls/src/create-control.tsx"),i=r("./packages/packages/libs/editor-controls/src/controls/transform-control/transform-content.tsx"),u=r("./packages/packages/libs/editor-controls/src/controls/transform-control/transform-icon.tsx"),p=r("./packages/packages/libs/editor-controls/src/controls/transform-control/transform-label.tsx"),d=r("./packages/packages/libs/editor-controls/src/controls/transform-control/types.ts");const m=(0,c.createControl)(()=>{const{propType:e,value:t,setValue:r,disabled:c}=(0,l.useBoundProp)(n.transformPropTypeUtil);return o.createElement(l.PropProvider,{propType:e,value:t,setValue:r},o.createElement(s.Repeater,{openOnAdd:!0,disabled:c,values:t??[],setValues:r,label:(0,a.__)("Transform","elementor"),showDuplicate:!1,itemSettings:{Icon:u.TransformIcon,Label:p.TransformLabel,Content:i.TransformContent,initialValues:d.initialTransformValue}}))})},"./packages/packages/libs/editor-controls/src/controls/transform-control/types.ts":function(e,t,r){r.r(t),r.d(t,{TransformFunctionKeys:function(){return n},defaultValues:function(){return a},initialRotateValue:function(){return c},initialScaleValue:function(){return s},initialSkewValue:function(){return i},initialTransformValue:function(){return l}});var o=r("@elementor/editor-props");const n={move:"transform-move",scale:"transform-scale",rotate:"transform-rotate",skew:"transform-skew"},a={move:{size:0,unit:"px"},scale:1,rotate:{size:0,unit:"deg"},skew:{size:0,unit:"deg"}},l={$$type:n.move,value:{x:{$$type:"size",value:{size:a.move.size,unit:a.move.unit}},y:{$$type:"size",value:{size:a.move.size,unit:a.move.unit}},z:{$$type:"size",value:{size:a.move.size,unit:a.move.unit}}}},s=o.scaleTransformPropTypeUtil.create({x:o.numberPropTypeUtil.create(a.scale),y:o.numberPropTypeUtil.create(a.scale),z:o.numberPropTypeUtil.create(a.scale)}),c=o.rotateTransformPropTypeUtil.create({x:{$$type:"size",value:{size:a.rotate.size,unit:a.rotate.unit}},y:{$$type:"size",value:{size:a.rotate.size,unit:a.rotate.unit}},z:{$$type:"size",value:{size:a.rotate.size,unit:a.rotate.unit}}}),i=o.skewTransformPropTypeUtil.create({x:{$$type:"size",value:{size:a.skew.size,unit:a.skew.unit}},y:{$$type:"size",value:{size:a.skew.size,unit:a.skew.unit}}})},"./packages/packages/libs/editor-controls/src/controls/transform-control/use-transform-tabs-history.tsx":function(e,t,r){r.r(t),r.d(t,{useTransformTabsHistory:function(){return useTransformTabsHistory}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),s=r("./packages/packages/libs/editor-controls/src/controls/transform-control/types.ts");const useTransformTabsHistory=({move:e,scale:t,rotate:r,skew:c})=>{const{value:i,setValue:u}=(0,l.useBoundProp)(n.moveTransformPropTypeUtil),{value:p,setValue:d}=(0,l.useBoundProp)(n.scaleTransformPropTypeUtil),{value:m,setValue:g}=(0,l.useBoundProp)(n.rotateTransformPropTypeUtil),{value:b,setValue:f}=(0,l.useBoundProp)(n.skewTransformPropTypeUtil),{getTabsProps:k,getTabProps:v,getTabPanelProps:x}=(0,a.useTabs)((()=>{switch(!0){case!!p:return s.TransformFunctionKeys.scale;case!!m:return s.TransformFunctionKeys.rotate;case!!b:return s.TransformFunctionKeys.skew;default:return s.TransformFunctionKeys.move}})()),y=(0,o.useRef)({move:e,scale:t,rotate:r,skew:c}),saveToHistory=(e,t)=>{t&&(y.current[e]=t)},onTabChange=(e,t)=>{switch(t){case s.TransformFunctionKeys.move:u(y.current.move),saveToHistory("scale",p),saveToHistory("rotate",m),saveToHistory("skew",b);break;case s.TransformFunctionKeys.scale:d(y.current.scale),saveToHistory("move",i),saveToHistory("rotate",m),saveToHistory("skew",b);break;case s.TransformFunctionKeys.rotate:g(y.current.rotate),saveToHistory("move",i),saveToHistory("scale",p),saveToHistory("skew",b);break;case s.TransformFunctionKeys.skew:f(y.current.skew),saveToHistory("move",i),saveToHistory("scale",p),saveToHistory("rotate",m)}return k().onChange(e,t)};return{getTabProps:v,getTabPanelProps:x,getTabsProps:()=>({...k(),onChange:onTabChange})}}},"./packages/packages/libs/editor-controls/src/controls/url-control.tsx":function(e,t,r){r.r(t),r.d(t,{UrlControl:function(){return c}});var o=r("react"),n=r("@elementor/editor-props"),a=r("@elementor/ui"),l=r("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),s=r("./packages/packages/libs/editor-controls/src/control-actions/control-actions.tsx");const c=(0,r("./packages/packages/libs/editor-controls/src/create-control.tsx").createControl)(({placeholder:e})=>{const{value:t,setValue:r,disabled:c}=(0,l.useBoundProp)(n.urlPropTypeUtil);return o.createElement(s.default,null,o.createElement(a.TextField,{size:"tiny",fullWidth:!0,value:t??"",disabled:c,onChange:e=>r(e.target.value),placeholder:e}))})},"./packages/packages/libs/editor-controls/src/create-control.tsx":function(e,t,r){r.r(t),r.d(t,{createControl:function(){return createControl}});var o=r("react"),n=r("@elementor/ui"),a=r("./packages/packages/libs/editor-controls/src/control-replacements.tsx");Symbol("control");function createControl(e){return t=>{const r=(0,a.useControlReplacement)(e);return o.createElement(n.ErrorBoundary,{fallback:null},o.createElement(r,t))}}},"./packages/packages/libs/editor-controls/src/env.ts":function(e,t,r){r.r(t),r.d(t,{env:function(){return n}});var o=r("@elementor/env");const{env:n}=(0,o.parseEnv)("@elementor/editor-controls")},"./packages/packages/libs/editor-controls/src/hooks/use-filtered-font-families.ts":function(e,t,r){r.r(t),r.d(t,{useFilteredFontFamilies:function(){return useFilteredFontFamilies}});const useFilteredFontFamilies=(e,t)=>e.reduce((e,r)=>{const o=r.fonts.filter(e=>e.toLowerCase().includes(t.toLowerCase()));return o.length&&(e.push({type:"category",value:r.label}),o.forEach(t=>{e.push({type:"font",value:t})})),e},[])},"./packages/packages/libs/editor-controls/src/hooks/use-repeatable-control-context.ts":function(e,t,r){r.r(t),r.d(t,{RepeatableControlContext:function(){return n},useRepeatableControlContext:function(){return useRepeatableControlContext}});var o=r("react");const n=(0,o.createContext)(void 0),useRepeatableControlContext=()=>{const e=(0,o.useContext)(n);if(!e)throw new Error("useRepeatableControlContext must be used within RepeatableControl");return e}},"./packages/packages/libs/editor-controls/src/hooks/use-size-extended-options.ts":function(e,t,r){r.r(t),r.d(t,{useSizeExtendedOptions:function(){return useSizeExtendedOptions}});var o=r("react");function useSizeExtendedOptions(e,t){return(0,o.useMemo)(()=>{const r=[...e];return t||r.includes("custom")?e.includes("custom")&&r.splice(r.indexOf("custom"),1):r.push("custom"),r},[e,t])}},"./packages/packages/libs/editor-controls/src/hooks/use-sync-external-state.tsx":function(e,t,r){r.r(t),r.d(t,{useSyncExternalState:function(){return useSyncExternalState}});var o=r("react");const useSyncExternalState=({external:e,setExternal:t,persistWhen:r,fallback:n})=>{function toInternal(e,t){return e||n(t)}const[a,l]=(0,o.useState)(toInternal(e,null));(0,o.useEffect)(()=>{l(t=>toInternal(e,t))},[e]);return[a,e=>{const o=("function"==typeof e?e:()=>e)(a);l(o),t(function toExternal(e){return r(e)?e:null}(o))}]}},"./packages/packages/libs/editor-controls/src/hooks/use-unfiltered-files-upload.ts":function(e,t,r){r.r(t),r.d(t,{UNFILTERED_FILES_UPLOAD_KEY:function(){return a},useUnfilteredFilesUpload:function(){return useUnfilteredFilesUpload},useUpdateUnfilteredFilesUpload:function(){return useUpdateUnfilteredFilesUpload}});var o=r("@elementor/query"),n=r("./packages/packages/libs/editor-controls/src/api.ts");const a="elementor_unfiltered_files_upload",l={queryKey:[a]},useUnfilteredFilesUpload=()=>(0,o.useQuery)({...l,queryFn:()=>n.apiClient.getElementorSetting(a).then(e=>formatResponse(e)),staleTime:1/0});function useUpdateUnfilteredFilesUpload(){const e=(0,o.useQueryClient)();return(0,o.useMutation)({mutationFn:({allowUnfilteredFilesUpload:e})=>n.apiClient.updateElementorSetting(a,e?"1":"0"),onSuccess:()=>e.invalidateQueries(l)})}const formatResponse=e=>Boolean("1"===e)},"./packages/packages/libs/editor-controls/src/locations.ts":function(e,t,r){r.r(t),r.d(t,{RepeaterItemIconSlot:function(){return n},RepeaterItemLabelSlot:function(){return l},injectIntoRepeaterItemIcon:function(){return a},injectIntoRepeaterItemLabel:function(){return s}});var o=r("@elementor/locations");const{Slot:n,inject:a}=(0,o.createReplaceableLocation)(),{Slot:l,inject:s}=(0,o.createReplaceableLocation)()},"./packages/packages/libs/editor-controls/src/utils/size-control.ts":function(e,t,r){r.r(t),r.d(t,{DEFAULT_SIZE:function(){return c},DEFAULT_UNIT:function(){return s},angleUnits:function(){return n},isUnitExtendedOption:function(){return isUnitExtendedOption},lengthUnits:function(){return o},timeUnits:function(){return a}});const o=["px","%","em","rem","vw","vh"],n=["deg","rad","grad","turn"],a=["s","ms"],l=["auto","custom"],s="px",c=NaN;function isUnitExtendedOption(e){return l.includes(e)}},"@elementor/editor-current-user":function(e){e.exports=window.elementorV2.editorCurrentUser},"@elementor/editor-elements":function(e){e.exports=window.elementorV2.editorElements},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-responsive":function(e){e.exports=window.elementorV2.editorResponsive},"@elementor/editor-ui":function(e){e.exports=window.elementorV2.editorUi},"@elementor/env":function(e){e.exports=window.elementorV2.env},"@elementor/http-client":function(e){e.exports=window.elementorV2.httpClient},"@elementor/icons":function(e){e.exports=window.elementorV2.icons},"@elementor/locations":function(e){e.exports=window.elementorV2.locations},"@elementor/query":function(e){e.exports=window.elementorV2.query},"@elementor/session":function(e){e.exports=window.elementorV2.session},"@elementor/ui":function(e){e.exports=window.elementorV2.ui},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@elementor/wp-media":function(e){e.exports=window.elementorV2.wpMedia},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},t={};function __webpack_require__(r){var o=t[r];if(void 0!==o)return o.exports;var n=t[r]={exports:{}};return e[r](n,n.exports,__webpack_require__),n.exports}__webpack_require__.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=function(e,t){for(var r in t)__webpack_require__.o(t,r)&&!__webpack_require__.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},__webpack_require__.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var r={};!function(){__webpack_require__.r(r),__webpack_require__.d(r,{AspectRatioControl:function(){return v.AspectRatioControl},BackgroundControl:function(){return y.BackgroundControl},BoxShadowRepeaterControl:function(){return l.BoxShadowRepeaterControl},ColorControl:function(){return i.ColorControl},ControlActionsProvider:function(){return O.ControlActionsProvider},ControlAdornments:function(){return $.ControlAdornments},ControlAdornmentsProvider:function(){return B.ControlAdornmentsProvider},ControlFormLabel:function(){return T.ControlFormLabel},ControlReplacementsProvider:function(){return I.ControlReplacementsProvider},ControlToggleButtonGroup:function(){return S.ControlToggleButtonGroup},EqualUnequalSizesControl:function(){return d.EqualUnequalSizesControl},FilterRepeaterControl:function(){return s.FilterRepeaterControl},FontFamilyControl:function(){return g.FontFamilyControl},FontFamilySelector:function(){return z.FontFamilySelector},GapControl:function(){return k.GapControl},ImageControl:function(){return e.ImageControl},KeyValueControl:function(){return h.KeyValueControl},LinkControl:function(){return f.LinkControl},LinkedDimensionsControl:function(){return m.LinkedDimensionsControl},NumberControl:function(){return p.NumberControl},PopoverContent:function(){return w.PopoverContent},PositionControl:function(){return P.PositionControl},PropKeyProvider:function(){return F.PropKeyProvider},PropProvider:function(){return F.PropProvider},RepeatableControl:function(){return _.RepeatableControl},SelectControl:function(){return c.SelectControl},SizeControl:function(){return n.SizeControl},StrokeControl:function(){return a.StrokeControl},SvgMediaControl:function(){return x.SvgMediaControl},SwitchControl:function(){return E.SwitchControl},TextAreaControl:function(){return o.TextAreaControl},TextControl:function(){return t.TextControl},ToggleControl:function(){return u.ToggleControl},TransformRepeaterControl:function(){return C.TransformRepeaterControl},UrlControl:function(){return b.UrlControl},createControlReplacementsRegistry:function(){return I.createControlReplacementsRegistry},injectIntoRepeaterItemIcon:function(){return V.injectIntoRepeaterItemIcon},injectIntoRepeaterItemLabel:function(){return V.injectIntoRepeaterItemLabel},useBoundProp:function(){return F.useBoundProp},useControlActions:function(){return O.useControlActions},useFloatingActionsBar:function(){return U.useFloatingActionsBar},useSyncExternalState:function(){return R.useSyncExternalState}});var e=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/image-control.tsx"),t=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/text-control.tsx"),o=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/text-area-control.tsx"),n=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/size-control.tsx"),a=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/stroke-control.tsx"),l=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/box-shadow-repeater-control.tsx"),s=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/filter-repeater-control.tsx"),c=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/select-control.tsx"),i=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/color-control.tsx"),u=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/toggle-control.tsx"),p=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/number-control.tsx"),d=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/equal-unequal-sizes-control.tsx"),m=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/linked-dimensions-control.tsx"),g=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/font-family-control/font-family-control.tsx"),b=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/url-control.tsx"),f=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/link-control.tsx"),k=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/gap-control.tsx"),v=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/aspect-ratio-control.tsx"),x=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/svg-media-control.tsx"),y=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/background-control/background-control.tsx"),E=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/switch-control.tsx"),_=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/repeatable-control.tsx"),h=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/key-value-control.tsx"),P=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/position-control.tsx"),C=__webpack_require__("./packages/packages/libs/editor-controls/src/controls/transform-control/transform-repeater-control.tsx"),w=__webpack_require__("./packages/packages/libs/editor-controls/src/components/popover-content.tsx"),T=__webpack_require__("./packages/packages/libs/editor-controls/src/components/control-form-label.tsx"),S=__webpack_require__("./packages/packages/libs/editor-controls/src/components/control-toggle-button-group.tsx"),z=__webpack_require__("./packages/packages/libs/editor-controls/src/components/font-family-selector.tsx"),I=__webpack_require__("./packages/packages/libs/editor-controls/src/control-replacements.tsx"),O=__webpack_require__("./packages/packages/libs/editor-controls/src/control-actions/control-actions-context.tsx"),U=__webpack_require__("./packages/packages/libs/editor-controls/src/components/floating-bar.tsx"),F=__webpack_require__("./packages/packages/libs/editor-controls/src/bound-prop-context/index.ts"),B=__webpack_require__("./packages/packages/libs/editor-controls/src/control-adornments/control-adornments-context.tsx"),$=__webpack_require__("./packages/packages/libs/editor-controls/src/control-adornments/control-adornments.tsx"),V=__webpack_require__("./packages/packages/libs/editor-controls/src/locations.ts"),R=__webpack_require__("./packages/packages/libs/editor-controls/src/hooks/use-sync-external-state.tsx")}(),(window.elementorV2=window.elementorV2||{}).editorControls=r}(),window.elementorV2.editorControls?.init?.();
//# sourceMappingURL=editor-controls.js.map